/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import javax.annotation.Nonnull;
import mekanism.api.text.EnumColor;
import mekanism.api.tier.AlloyTier;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.common.MekanismLang;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;

public class TileEntityDiversionTransporter
extends TileEntityLogisticalTransporter {
    public int[] modes = new int[]{0, 0, 0, 0, 0, 0};

    public TileEntityDiversionTransporter() {
        super(MekanismBlocks.DIVERSION_TRANSPORTER);
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.DIVERSION_TRANSPORTER;
    }

    @Override
    public void onNeighborBlockChange(Direction side) {
        byte current = this.getAllCurrentConnections();
        this.refreshConnections();
        if (current != this.getAllCurrentConnections()) {
            this.markDirtyTransmitters();
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        NBTUtils.setIntArrayIfPresent(nbtTags, "modes", modes -> {
            this.modes = modes;
        });
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        nbtTags.func_74783_a("modes", this.modes);
        return nbtTags;
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        for (int i = 0; i < EnumUtils.DIRECTIONS.length; ++i) {
            updateTag.func_74768_a("mode" + i, this.modes[i]);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        int i = 0;
        while (i < EnumUtils.DIRECTIONS.length) {
            int index = i++;
            NBTUtils.setIntIfPresent(tag, "mode" + index, mode -> {
                this.modes[index] = mode;
            });
        }
    }

    @Override
    protected ActionResultType onConfigure(PlayerEntity player, int part, Direction side) {
        MekanismLang langEntry;
        int newMode;
        this.modes[side.ordinal()] = newMode = (this.modes[side.ordinal()] + 1) % 3;
        switch (newMode) {
            case 0: {
                langEntry = MekanismLang.DIVERSION_CONTROL_DISABLED;
                break;
            }
            case 1: {
                langEntry = MekanismLang.DIVERSION_CONTROL_HIGH;
                break;
            }
            case 2: {
                langEntry = MekanismLang.DIVERSION_CONTROL_LOW;
                break;
            }
            default: {
                langEntry = MekanismLang.NONE;
            }
        }
        this.refreshConnections();
        this.notifyTileChange();
        player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.TOGGLE_DIVERTER.translateColored(EnumColor.GRAY, new Object[]{EnumColor.RED, langEntry})));
        this.sendUpdatePacket();
        return ActionResultType.SUCCESS;
    }

    @Override
    public boolean canConnect(Direction side) {
        if (!super.canConnect(side)) {
            return false;
        }
        int mode = this.modes[side.ordinal()];
        boolean redstone = MekanismUtils.isGettingPowered(this.func_145831_w(), this.func_174877_v());
        return !(mode == 2 && redstone || mode == 1 && !redstone);
    }

    @Override
    public EnumColor getRenderColor() {
        return null;
    }

    @Override
    @Nonnull
    protected TransmitterModelData.Diversion initModelData() {
        return new TransmitterModelData.Diversion();
    }

    @Override
    protected boolean canUpgrade(AlloyTier tier) {
        return false;
    }
}

