/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.component.config;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.util.EnumUtils;
import net.minecraft.util.Direction;

public class ConfigInfo {
    private final Supplier<Direction> facingSupplier;
    private boolean canEject;
    private boolean ejecting;
    private Map<RelativeSide, DataType> sideConfig;
    private Map<DataType, ISlotInfo> slotInfo;

    public ConfigInfo(@Nonnull Supplier<Direction> facingSupplier) {
        this.facingSupplier = facingSupplier;
        this.canEject = true;
        this.ejecting = false;
        this.sideConfig = new EnumMap<RelativeSide, DataType>(RelativeSide.class);
        for (RelativeSide side : EnumUtils.SIDES) {
            this.sideConfig.put(side, DataType.NONE);
        }
        this.slotInfo = new EnumMap<DataType, ISlotInfo>(DataType.class);
    }

    private RelativeSide getSide(Direction direction) {
        return RelativeSide.fromDirections(this.facingSupplier.get(), direction);
    }

    public boolean canEject() {
        return this.canEject;
    }

    public void setCanEject(boolean canEject) {
        this.canEject = canEject;
    }

    public boolean isEjecting() {
        return this.ejecting;
    }

    public void setEjecting(boolean ejecting) {
        this.ejecting = ejecting;
    }

    @Nonnull
    public DataType getDataType(@Nonnull RelativeSide side) {
        return this.sideConfig.get((Object)side);
    }

    public void setDataType(@Nonnull RelativeSide side, @Nonnull DataType dataType) {
        this.sideConfig.put(side, dataType);
    }

    @Nonnull
    public Set<DataType> getSupportedDataTypes() {
        EnumSet<DataType> dataTypes = EnumSet.of(DataType.NONE);
        dataTypes.addAll(this.slotInfo.keySet());
        return dataTypes;
    }

    public void fill(@Nonnull DataType dataType) {
        for (RelativeSide side : EnumUtils.SIDES) {
            this.setDataType(side, dataType);
        }
    }

    @Nullable
    public ISlotInfo getSlotInfo(@Nonnull RelativeSide side) {
        return this.getSlotInfo(this.getDataType(side));
    }

    @Nullable
    public ISlotInfo getSlotInfo(@Nonnull DataType dataType) {
        return this.slotInfo.get(dataType);
    }

    public void addSlotInfo(@Nonnull DataType dataType, @Nonnull ISlotInfo info) {
        this.slotInfo.put(dataType, info);
    }

    public Set<Direction> getSidesForData(@Nonnull DataType dataType) {
        Direction facing = this.facingSupplier.get();
        return this.sideConfig.entrySet().stream().filter(entry -> ((DataType)entry.getValue()).equals(dataType)).map(entry -> ((RelativeSide)((Object)((Object)entry.getKey()))).getDirection(facing)).collect(Collectors.toCollection(() -> EnumSet.noneOf(Direction.class)));
    }

    @Nonnull
    public DataType incrementDataType(@Nonnull RelativeSide relativeSide) {
        Set<DataType> supportedDataTypes = this.getSupportedDataTypes();
        DataType newType = this.getDataType(relativeSide).getNext(supportedDataTypes::contains);
        this.sideConfig.put(relativeSide, newType);
        return newType;
    }

    @Nonnull
    public DataType decrementDataType(@Nonnull RelativeSide relativeSide) {
        Set<DataType> supportedDataTypes = this.getSupportedDataTypes();
        DataType newType = this.getDataType(relativeSide).getPrevious(supportedDataTypes::contains);
        this.sideConfig.put(relativeSide, newType);
        return newType;
    }
}

