/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.common.Mekanism;
import mekanism.common.base.IBoundingBlock;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableEnum;
import mekanism.common.inventory.container.sync.list.SyncableStringList;
import mekanism.common.inventory.slot.SecurityInventorySlot;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntitySecurityDesk
extends TileEntityMekanism
implements IBoundingBlock {
    public UUID ownerUUID;
    public String clientOwner;
    public SecurityFrequency frequency;
    private SecurityInventorySlot unlockSlot;
    private SecurityInventorySlot lockSlot;

    public TileEntitySecurityDesk() {
        super(MekanismBlocks.SECURITY_DESK);
        this.addDisabledCapabilities(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.unlockSlot = SecurityInventorySlot.unlock(() -> this.ownerUUID, this, 146, 18);
        builder.addSlot(this.unlockSlot);
        this.lockSlot = SecurityInventorySlot.lock(this, 146, 97);
        builder.addSlot(this.lockSlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        FrequencyManager manager;
        super.onUpdateServer();
        if (this.ownerUUID != null && this.frequency != null) {
            this.unlockSlot.unlock(this.ownerUUID);
            this.lockSlot.lock(this.ownerUUID, this.frequency);
        }
        if (this.frequency == null && this.ownerUUID != null) {
            this.setFrequency(this.ownerUUID);
        }
        if ((manager = this.getManager(this.frequency)) != null) {
            if (this.frequency != null && !this.frequency.valid) {
                this.frequency = (SecurityFrequency)manager.validateFrequency(this.ownerUUID, Coord4D.get(this), this.frequency);
            }
            if (this.frequency != null) {
                this.frequency = (SecurityFrequency)manager.update(Coord4D.get(this), this.frequency);
            }
        } else {
            this.frequency = null;
        }
    }

    public FrequencyManager getManager(Frequency freq) {
        if (this.ownerUUID == null || freq == null) {
            return null;
        }
        return Mekanism.securityFrequencies;
    }

    public void setFrequency(UUID owner) {
        FrequencyManager manager = Mekanism.securityFrequencies;
        manager.deactivate(Coord4D.get(this));
        for (Frequency freq : manager.getFrequencies()) {
            if (!freq.ownerUUID.equals(owner)) continue;
            this.frequency = (SecurityFrequency)freq;
            this.frequency.activeCoords.add(Coord4D.get(this));
            this.sendUpdatePacket();
            return;
        }
        Frequency freq = new SecurityFrequency(owner).setPublic(true);
        freq.activeCoords.add(Coord4D.get(this));
        manager.addFrequency(freq);
        this.frequency = (SecurityFrequency)freq;
        this.markDirty(false);
        this.sendUpdatePacket();
    }

    public void toggleOverride() {
        if (this.frequency != null) {
            this.frequency.override = !this.frequency.override;
            this.markDirty(false);
        }
    }

    public void removeTrusted(int index) {
        if (this.frequency != null) {
            this.frequency.removeTrusted(index);
            this.markDirty(false);
        }
    }

    public void setSecurityMode(ISecurityTile.SecurityMode mode) {
        if (this.frequency != null) {
            this.frequency.securityMode = mode;
            this.markDirty(false);
        }
    }

    public void addTrusted(String name) {
        GameProfile profile;
        if (this.frequency != null && (profile = ServerLifecycleHooks.getCurrentServer().func_152358_ax().func_152655_a(name)) != null) {
            this.frequency.addTrusted(profile.getId(), profile.getName());
            this.markDirty(false);
        }
    }

    @Override
    public void func_145839_a(CompoundNBT nbtTags) {
        super.func_145839_a(nbtTags);
        NBTUtils.setUUIDIfPresent(nbtTags, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        if (nbtTags.func_150297_b("frequency", 10)) {
            this.frequency = new SecurityFrequency(nbtTags.func_74775_l("frequency"), false);
            this.frequency.valid = false;
        }
    }

    @Override
    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT nbtTags) {
        super.func_189515_b(nbtTags);
        if (this.ownerUUID != null) {
            nbtTags.func_186854_a("owner", this.ownerUUID);
        }
        if (this.frequency != null) {
            CompoundNBT frequencyTag = new CompoundNBT();
            this.frequency.write(frequencyTag);
            nbtTags.func_218657_a("frequency", (INBT)frequencyTag);
        }
        return nbtTags;
    }

    @Override
    public void func_145843_s() {
        FrequencyManager manager;
        super.func_145843_s();
        if (!this.isRemote() && this.frequency != null && (manager = this.getManager(this.frequency)) != null) {
            manager.deactivate(Coord4D.get(this));
        }
    }

    @Override
    public void onPlace() {
        MekanismUtils.makeBoundingBlock((IWorld)this.func_145831_w(), this.func_174877_v().func_177984_a(), this.func_174877_v());
    }

    @Override
    public void onBreak() {
        World world = this.func_145831_w();
        if (world != null) {
            world.func_217377_a(this.func_174877_v().func_177984_a(), false);
            world.func_217377_a(this.func_174877_v(), false);
        }
    }

    @Override
    public Frequency getFrequency(FrequencyManager manager) {
        if (manager == Mekanism.securityFrequencies) {
            return this.frequency;
        }
        return null;
    }

    @Nonnull
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 2, 1));
    }

    @Override
    @Nonnull
    public CompoundNBT getReducedUpdateTag() {
        CompoundNBT updateTag = super.getReducedUpdateTag();
        if (this.ownerUUID != null) {
            updateTag.func_186854_a("owner", this.ownerUUID);
            updateTag.func_74778_a("ownerName", MekanismUtils.getLastKnownUsername(this.ownerUUID));
        }
        if (this.frequency != null) {
            CompoundNBT frequencyTag = new CompoundNBT();
            this.frequency.writeToUpdateTag(frequencyTag);
            updateTag.func_218657_a("frequency", (INBT)frequencyTag);
        }
        return updateTag;
    }

    @Override
    public void handleUpdateTag(@Nonnull CompoundNBT tag) {
        super.handleUpdateTag(tag);
        NBTUtils.setUUIDIfPresent(tag, "owner", uuid -> {
            this.ownerUUID = uuid;
        });
        NBTUtils.setStringIfPresent(tag, "ownerName", uuid -> {
            this.clientOwner = uuid;
        });
        NBTUtils.setCompoundIfPresent(tag, "frequency", nbt -> {
            this.frequency = new SecurityFrequency((CompoundNBT)nbt, true);
        });
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.frequency != null && this.frequency.override, value -> {
            if (this.frequency != null) {
                this.frequency.override = value;
            }
        }));
        container.track(SyncableEnum.create(ISecurityTile.SecurityMode::byIndexStatic, ISecurityTile.SecurityMode.PUBLIC, () -> this.frequency == null ? ISecurityTile.SecurityMode.PUBLIC : this.frequency.securityMode, value -> {
            if (this.frequency != null) {
                this.frequency.securityMode = value;
            }
        }));
        container.track(SyncableStringList.create(() -> this.frequency == null ? Collections.emptyList() : this.frequency.trustedCache, value -> {
            if (this.frequency != null) {
                this.frequency.trustedCache = value;
            }
        }));
    }
}

