/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.IConfigurable;
import mekanism.api.text.EnumColor;
import mekanism.common.MekanismLang;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.energy.ProxiedEnergyContainerHolder;
import mekanism.common.capabilities.resolver.basic.BasicCapabilityResolver;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.CableUtils;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;

public class TileEntityInductionPort
extends TileEntityInductionCasing
implements IConfigurable {
    public TileEntityInductionPort() {
        super(MekanismBlocks.INDUCTION_PORT);
        this.delaySupplier = () -> 0;
        this.addCapabilityResolver(BasicCapabilityResolver.constant(Capabilities.CONFIGURABLE_CAPABILITY, this));
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        return ProxiedEnergyContainerHolder.create(side -> !this.getActive(), side -> this.getActive(), side -> this.structure == null ? Collections.emptyList() : ((SynchronizedMatrixData)this.structure).getEnergyContainers((Direction)side));
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure != null && this.getActive()) {
            CableUtils.emit(((SynchronizedMatrixData)this.structure).getDirectionsToEmit(Coord4D.get(this)), ((SynchronizedMatrixData)this.structure).getEnergyContainer(), (TileEntity)this);
        }
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.ENERGY) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public ActionResultType onSneakRightClick(PlayerEntity player, Direction side) {
        if (!this.isRemote()) {
            boolean oldMode = this.getActive();
            this.setActive(!oldMode);
            player.func_145747_a(MekanismLang.LOG_FORMAT.translateColored(EnumColor.DARK_BLUE, MekanismLang.MEKANISM, MekanismLang.INDUCTION_PORT_MODE.translateColored(EnumColor.GRAY, BooleanStateDisplay.InputOutput.of(oldMode, true))));
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResultType onRightClick(PlayerEntity player, Direction side) {
        return ActionResultType.PASS;
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public int getRedstoneLevel() {
        return this.structure == null ? 0 : ((SynchronizedMatrixData)this.structure).getCurrentRedstoneLevel();
    }
}

