/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.FloatingLong;
import mekanism.api.recipes.ChemicalInfuserRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ChemicalInfuserCachedRecipe;
import mekanism.api.recipes.inputs.GasStackIngredient;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.interfaces.ITileCachedRecipeHolder;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;

public class TileEntityChemicalInfuser
extends TileEntityMekanism
implements ITileCachedRecipeHolder<ChemicalInfuserRecipe> {
    public static final long MAX_GAS = 10000L;
    public BasicGasTank leftTank;
    public BasicGasTank rightTank;
    public BasicGasTank centerTank;
    public long gasOutput = 256L;
    public CachedRecipe<ChemicalInfuserRecipe> cachedRecipe;
    public FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull GasStack> leftInputHandler = InputHelper.getInputHandler(this.leftTank);
    private final IInputHandler<@NonNull GasStack> rightInputHandler = InputHelper.getInputHandler(this.rightTank);
    private MachineEnergyContainer<TileEntityChemicalInfuser> energyContainer;
    private GasInventorySlot leftInputSlot;
    private GasInventorySlot outputSlot;
    private GasInventorySlot rightInputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityChemicalInfuser() {
        super(MekanismBlocks.CHEMICAL_INFUSER);
        this.outputHandler = OutputHelper.getOutputHandler(this.centerTank);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGas(this::getDirection);
        this.leftTank = BasicGasTank.input(10000L, gas -> this.isValidGas((Gas)gas, this.rightTank), this::isValidGas, this);
        builder.addTank(this.leftTank, RelativeSide.LEFT);
        this.rightTank = BasicGasTank.input(10000L, gas -> this.isValidGas((Gas)gas, this.leftTank), this::isValidGas, this);
        builder.addTank(this.rightTank, RelativeSide.RIGHT);
        this.centerTank = BasicGasTank.output(10000L, this);
        builder.addTank(this.centerTank, RelativeSide.FRONT);
        return builder.build();
    }

    private boolean isValidGas(@Nonnull Gas gas) {
        return this.containsRecipe(recipe -> recipe.getLeftInput().testType(gas) || recipe.getRightInput().testType(gas));
    }

    private boolean isValidGas(@Nonnull Gas gas, IGasTank otherTank) {
        if (otherTank.isEmpty()) {
            return true;
        }
        GasStack stack = (GasStack)otherTank.getStack();
        return this.containsRecipe(recipe -> {
            GasStackIngredient leftInput = recipe.getLeftInput();
            GasStackIngredient rightInput = recipe.getRightInput();
            return rightInput.testType(gas) && leftInput.testType(stack) || leftInput.testType(gas) && rightInput.testType(stack);
        });
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.leftInputSlot = GasInventorySlot.fill(this.leftTank, this, 5, 56);
        builder.addSlot(this.leftInputSlot, RelativeSide.LEFT);
        this.rightInputSlot = GasInventorySlot.fill(this.rightTank, this, 155, 56);
        builder.addSlot(this.rightInputSlot, RelativeSide.RIGHT);
        this.outputSlot = GasInventorySlot.drain(this.centerTank, this, 80, 65);
        builder.addSlot(this.outputSlot, RelativeSide.FRONT);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalInfuser)this).func_145831_w(), this, 155, 5);
        builder.addSlot(this.energySlot, RelativeSide.BOTTOM, RelativeSide.TOP);
        this.leftInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.leftInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.rightInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.rightInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.leftInputSlot.fillTank();
        this.rightInputSlot.fillTank();
        this.outputSlot.drainTank();
        FloatingLong prev = this.energyContainer.getEnergy().copyAsConst();
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        this.clientEnergyUsed = prev.subtract(this.energyContainer.getEnergy());
        GasUtils.emit(EnumSet.of(this.getDirection()), this.centerTank, this, this.gasOutput);
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ChemicalInfuserRecipe> getRecipeType() {
        return MekanismRecipeType.CHEMICAL_INFUSING;
    }

    @Override
    @Nullable
    public CachedRecipe<ChemicalInfuserRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public ChemicalInfuserRecipe getRecipe(int cacheIndex) {
        GasStack leftGas = this.leftInputHandler.getInput();
        if (leftGas.isEmpty()) {
            return null;
        }
        GasStack rightGas = this.rightInputHandler.getInput();
        if (rightGas.isEmpty()) {
            return null;
        }
        return (ChemicalInfuserRecipe)this.findFirstRecipe(recipe -> recipe.test(leftGas, rightGas));
    }

    @Override
    @Nullable
    public CachedRecipe<ChemicalInfuserRecipe> createNewCachedRecipe(@Nonnull ChemicalInfuserRecipe recipe, int cacheIndex) {
        return new ChemicalInfuserCachedRecipe(recipe, this.leftInputHandler, this.rightInputHandler, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            return Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
        });
    }

    @Override
    public boolean renderUpdate() {
        return true;
    }

    @Override
    public boolean lightUpdate() {
        return true;
    }

    public MachineEnergyContainer<TileEntityChemicalInfuser> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableFloatingLong.create(() -> this.clientEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }
}

