/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.EnumSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.recipes.ItemStackGasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.ItemStackGasToGasCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.GasInventorySlot;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentUpgrade;
import mekanism.common.tile.prefab.TileEntityOperationalMachine;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StatUtils;
import net.minecraft.item.ItemStack;

public class TileEntityChemicalDissolutionChamber
extends TileEntityOperationalMachine<ItemStackGasToGasRecipe> {
    public static final long MAX_GAS = 10000L;
    public static final int BASE_INJECT_USAGE = 1;
    public static final int BASE_TICKS_REQUIRED = 100;
    public BasicGasTank injectTank;
    public BasicGasTank outputTank;
    public double injectUsage = 1.0;
    public long injectUsageThisTick;
    public long gasOutput = 256L;
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler = InputHelper.getInputHandler(this.inputSlot);
    private final ILongInputHandler<@NonNull GasStack> gasInputHandler = InputHelper.getInputHandler(this.injectTank);
    private MachineEnergyContainer<TileEntityChemicalDissolutionChamber> energyContainer;
    private GasInventorySlot gasInputSlot;
    private InputInventorySlot inputSlot;
    private GasInventorySlot outputSlot;
    private EnergyInventorySlot energySlot;

    public TileEntityChemicalDissolutionChamber() {
        super(MekanismBlocks.CHEMICAL_DISSOLUTION_CHAMBER, 100);
        this.outputHandler = OutputHelper.getOutputHandler(this.outputTank);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGas(this::getDirection);
        this.injectTank = BasicGasTank.input(10000L, gas -> this.containsRecipe(recipe -> recipe.getGasInput().testType((Gas)gas)), this);
        builder.addTank(this.injectTank, RelativeSide.LEFT);
        this.outputTank = BasicGasTank.ejectOutput(10000L, this);
        builder.addTank(this.outputTank, RelativeSide.RIGHT);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSide(this::getDirection);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSide(this::getDirection);
        this.gasInputSlot = GasInventorySlot.fillOrConvert(this.injectTank, () -> ((TileEntityChemicalDissolutionChamber)this).func_145831_w(), this, 6, 65);
        builder.addSlot(this.gasInputSlot, RelativeSide.BOTTOM);
        this.inputSlot = InputInventorySlot.at(item -> this.containsRecipe(recipe -> recipe.getItemInput().testType(item)), this, 26, 36);
        builder.addSlot(this.inputSlot, RelativeSide.TOP, RelativeSide.LEFT);
        this.outputSlot = GasInventorySlot.drain(this.outputTank, this, 155, 25);
        builder.addSlot(this.outputSlot, RelativeSide.RIGHT);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityChemicalDissolutionChamber)this).func_145831_w(), this, 155, 5);
        builder.addSlot(this.energySlot);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.outputSlot.setSlotOverlay(SlotOverlay.PLUS);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        this.gasInputSlot.fillTankOrConvert();
        this.outputSlot.drainTank();
        this.injectUsageThisTick = StatUtils.inversePoisson(this.injectUsage);
        this.cachedRecipe = this.getUpdatedCache(0);
        if (this.cachedRecipe != null) {
            this.cachedRecipe.process();
        }
        GasUtils.emit(EnumSet.of(this.getRightSide()), this.outputTank, this, this.gasOutput);
    }

    @Override
    @Nonnull
    public MekanismRecipeType<ItemStackGasToGasRecipe> getRecipeType() {
        return MekanismRecipeType.DISSOLUTION;
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackGasToGasRecipe> getCachedRecipe(int cacheIndex) {
        return this.cachedRecipe;
    }

    @Override
    @Nullable
    public ItemStackGasToGasRecipe getRecipe(int cacheIndex) {
        ItemStack stack = this.itemInputHandler.getInput();
        if (stack.func_190926_b()) {
            return null;
        }
        GasStack gasStack = (GasStack)this.gasInputHandler.getInput();
        if (gasStack.isEmpty()) {
            return null;
        }
        return (ItemStackGasToGasRecipe)this.findFirstRecipe(recipe -> recipe.test(stack, gasStack));
    }

    @Override
    @Nullable
    public CachedRecipe<ItemStackGasToGasRecipe> createNewCachedRecipe(@Nonnull ItemStackGasToGasRecipe recipe, int cacheIndex) {
        return new ItemStackGasToGasCachedRecipe(recipe, this.itemInputHandler, this.gasInputHandler, () -> this.injectUsageThisTick, this.outputHandler).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setRequiredTicks(() -> this.ticksRequired).setOnFinish(() -> this.markDirty(false)).setOperatingTicksChanged(this::setOperatingTicks);
    }

    @Override
    public TileComponentUpgrade getComponent() {
        return this.upgradeComponent;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgrade) {
        super.recalculateUpgrades(upgrade);
        if (upgrade == Upgrade.GAS || upgrade == Upgrade.SPEED) {
            this.injectUsage = MekanismUtils.getGasPerTickMean(this, 1L);
        }
    }

    public MachineEnergyContainer<TileEntityChemicalDissolutionChamber> getEnergyContainer() {
        return this.energyContainer;
    }
}

