/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.Coord4D;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.multiblock.IValveHandler;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.tile.base.SubstanceType;
import mekanism.common.util.GasUtils;
import net.minecraft.util.Direction;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileEntityBoilerValve
extends TileEntityBoilerCasing {
    public TileEntityBoilerValve() {
        super(MekanismBlocks.BOILER_VALVE);
        this.addSemiDisabledCapability(Capabilities.GAS_HANDLER_CAPABILITY, () -> this.structure != null && (((SynchronizedBoilerData)this.structure).upperRenderLocation == null || this.func_174877_v().func_177956_o() < ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1));
        this.addSemiDisabledCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, () -> this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1);
    }

    @Override
    @Nonnull
    protected IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        return side -> this.structure == null ? Collections.emptyList() : ((SynchronizedBoilerData)this.structure).getGasTanks(side);
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        return side -> this.structure == null ? Collections.emptyList() : ((SynchronizedBoilerData)this.structure).getFluidTanks(side);
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1) {
            GasUtils.emit(((SynchronizedBoilerData)this.structure).steamTank, this);
        }
    }

    @Override
    public boolean persists(SubstanceType type) {
        if (type == SubstanceType.FLUID || type == SubstanceType.GAS) {
            return false;
        }
        return super.persists(type);
    }

    @Override
    public int getRedstoneLevel() {
        return this.structure == null ? 0 : ((SynchronizedBoilerData)this.structure).getCurrentRedstoneLevel();
    }

    @Override
    public FluidStack insertFluid(FluidStack stack, Direction side, Action action) {
        FluidStack ret = super.insertFluid(stack, side, action);
        if (ret.getAmount() < stack.getAmount() && action.execute() && this.structure != null) {
            Coord4D coord4D = Coord4D.get(this);
            for (IValveHandler.ValveData data : ((SynchronizedBoilerData)this.structure).valves) {
                if (!coord4D.equals(data.location)) continue;
                data.onTransfer();
            }
        }
        return ret;
    }
}

