/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IConfigCardAccess;
import mekanism.api.Upgrade;
import mekanism.common.Mekanism;
import mekanism.common.base.IAdvancedBoundingBlock;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.registries.MekanismTileEntityTypes;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.component.TileComponentUpgrade;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class TileEntityAdvancedBoundingBlock
extends TileEntityBoundingBlock
implements IConfigCardAccess.ISpecialConfigData,
IUpgradeTile {
    public TileEntityAdvancedBoundingBlock() {
        super(MekanismTileEntityTypes.ADVANCED_BOUNDING_BLOCK.getTileEntityType());
    }

    public IAdvancedBoundingBlock getInv() {
        TileEntity tile = this.getMainTile();
        if (tile == null) {
            return null;
        }
        if (!(tile instanceof IAdvancedBoundingBlock)) {
            Mekanism.logger.error("Found tile {} instead of an IAdvancedBoundingBlock, at {}. Multiblock cannot function", (Object)tile, (Object)this.getMainPos());
            return null;
        }
        return (IAdvancedBoundingBlock)tile;
    }

    @Override
    public void onPower() {
        super.onPower();
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv != null) {
            inv.onPower();
        }
    }

    @Override
    public void onNoPower() {
        super.onNoPower();
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv != null) {
            inv.onNoPower();
        }
    }

    @Override
    public CompoundNBT getConfigurationData(CompoundNBT nbtTags) {
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv == null) {
            return new CompoundNBT();
        }
        return inv.getConfigurationData(nbtTags);
    }

    @Override
    public void setConfigurationData(CompoundNBT nbtTags) {
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv == null) {
            return;
        }
        inv.setConfigurationData(nbtTags);
    }

    @Override
    public String getDataType() {
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv == null) {
            return "null";
        }
        return inv.getDataType();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv == null) {
            return super.getCapability(capability, side);
        }
        return inv.getOffsetCapability(capability, side, (Vec3i)this.field_174879_c.func_177973_b((Vec3i)this.getMainPos()));
    }

    @Override
    public boolean supportsUpgrades() {
        IAdvancedBoundingBlock inv = this.getInv();
        return inv instanceof IUpgradeTile && ((IUpgradeTile)((Object)inv)).supportsUpgrades();
    }

    @Override
    public TileComponentUpgrade getComponent() {
        IUpgradeTile upgradeTile;
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)((Object)inv)).supportsUpgrades()) {
            return upgradeTile.getComponent();
        }
        return null;
    }

    @Override
    public void recalculateUpgrades(Upgrade upgradeType) {
        IUpgradeTile upgradeTile;
        IAdvancedBoundingBlock inv = this.getInv();
        if (inv instanceof IUpgradeTile && (upgradeTile = (IUpgradeTile)((Object)inv)).supportsUpgrades()) {
            upgradeTile.recalculateUpgrades(upgradeType);
        }
    }
}

