/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.registration.impl;

import java.util.function.Supplier;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.attribute.ChemicalAttribute;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasBuilder;
import mekanism.api.chemical.gas.Slurry;
import mekanism.common.Resource;
import mekanism.common.base.IChemicalConstant;
import mekanism.common.registration.WrappedDeferredRegister;
import mekanism.common.registration.impl.GasRegistryObject;
import mekanism.common.registration.impl.SlurryRegistryObject;
import net.minecraftforge.fml.RegistryObject;

public class GasDeferredRegister
extends WrappedDeferredRegister<Gas> {
    public GasDeferredRegister(String modid) {
        super(modid, MekanismAPI.GAS_REGISTRY);
    }

    public GasRegistryObject<Gas> register(IChemicalConstant constants) {
        return this.register(constants.getName(), constants.getColor(), new ChemicalAttribute[0]);
    }

    public GasRegistryObject<Gas> register(String name, int color, ChemicalAttribute ... attributes) {
        return this.register(name, () -> {
            GasBuilder builder = (GasBuilder)GasBuilder.builder().color(color);
            for (ChemicalAttribute attribute : attributes) {
                builder.with(attribute);
            }
            return new Gas(builder);
        });
    }

    public <GAS extends Gas> GasRegistryObject<GAS> register(String name, Supplier<? extends GAS> sup) {
        return this.register(name, sup, GasRegistryObject::new);
    }

    public SlurryRegistryObject<Slurry, Slurry> registerSlurry(Resource resource) {
        String baseSlurryName = resource.getRegistrySuffix() + "_slurry";
        return new SlurryRegistryObject<Slurry, Slurry>((RegistryObject<Slurry>)this.internal.register("dirty_" + baseSlurryName, () -> new Slurry(false, resource.getTint(), resource.getOreTag())), (RegistryObject<Slurry>)this.internal.register("clean_" + baseSlurryName, () -> new Slurry(true, resource.getTint(), resource.getOreTag())));
    }
}

