/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container;

import javax.annotation.Nullable;
import mekanism.common.frequency.Frequency;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.container.PacketUpdateContainer;
import net.minecraft.network.PacketBuffer;

public class PacketUpdateContainerFrequency<FREQUENCY extends Frequency>
extends PacketUpdateContainer<PacketUpdateContainerFrequency<FREQUENCY>> {
    @Nullable
    private final FREQUENCY value;

    public PacketUpdateContainerFrequency(short windowId, short property, @Nullable FREQUENCY value) {
        super(windowId, property);
        this.value = value;
    }

    private PacketUpdateContainerFrequency(PacketBuffer buffer) {
        super(buffer);
        this.value = buffer.readBoolean() ? Frequency.readFromPacket(buffer) : null;
    }

    @Override
    protected void encode(PacketBuffer buffer) {
        super.encode(buffer);
        if (this.value == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            ((Frequency)this.value).write(buffer);
        }
    }

    @Override
    protected void handle(MekanismContainer container, PacketUpdateContainerFrequency<FREQUENCY> message) {
        container.handleWindowProperty(message.property, message.value);
    }

    public static <FREQUENCY extends Frequency> PacketUpdateContainerFrequency<FREQUENCY> decode(PacketBuffer buf) {
        return new PacketUpdateContainerFrequency<FREQUENCY>(buf);
    }
}

