/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.container;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.network.container.property.PropertyData;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketUpdateContainerBatch {
    private final short windowId;
    private final List<PropertyData> data;

    public PacketUpdateContainerBatch(short windowId, List<PropertyData> data) {
        this.windowId = windowId;
        this.data = data;
    }

    public static void handle(PacketUpdateContainerBatch message, Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> {
            PlayerEntity player = BasePacketHandler.getPlayer(context);
            if (player.field_71070_bA instanceof MekanismContainer && player.field_71070_bA.field_75152_c == message.windowId) {
                message.data.forEach(data -> data.handleWindowProperty((MekanismContainer)player.field_71070_bA));
            }
        });
        ctx.setPacketHandled(true);
    }

    public static void encode(PacketUpdateContainerBatch pkt, PacketBuffer buffer) {
        buffer.writeByte((int)pkt.windowId);
        buffer.func_150787_b(pkt.data.size());
        for (PropertyData data : pkt.data) {
            data.writeToPacket(buffer);
        }
    }

    public static PacketUpdateContainerBatch decode(PacketBuffer buffer) {
        short windowId = buffer.readUnsignedByte();
        int size = buffer.func_150792_a();
        ArrayList<PropertyData> data = new ArrayList<PropertyData>(size);
        for (int i = 0; i < size; ++i) {
            PropertyData propertyData = PropertyData.fromBuffer(buffer);
            if (propertyData == null) continue;
            data.add(propertyData);
        }
        return new PacketUpdateContainerBatch(windowId, data);
    }
}

