/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.function.Supplier;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Hand;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSecurityMode {
    private final Hand currentHand;
    private final ISecurityTile.SecurityMode value;

    public PacketSecurityMode(Hand hand, ISecurityTile.SecurityMode control) {
        this.currentHand = hand;
        this.value = control;
    }

    public static void handle(PacketSecurityMode message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            ItemStack stack = player.func_184586_b(message.currentHand);
            if (stack.func_77973_b() instanceof ISecurityItem) {
                ((ISecurityItem)stack.func_77973_b()).setSecurity(stack, message.value);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketSecurityMode pkt, PacketBuffer buf) {
        buf.func_179249_a((Enum)pkt.currentHand);
        buf.func_179249_a((Enum)pkt.value);
    }

    public static PacketSecurityMode decode(PacketBuffer buf) {
        return new PacketSecurityMode((Hand)buf.func_179257_a(Hand.class), (ISecurityTile.SecurityMode)buf.func_179257_a(ISecurityTile.SecurityMode.class));
    }
}

