/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import java.util.Optional;
import java.util.function.Supplier;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IInfusionTank;
import mekanism.api.chemical.infuse.IMekanismInfusionHandler;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.BasePacketHandler;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketDropperUse {
    private final BlockPos pos;
    private final DropperAction action;
    private final TankType tankType;
    private final int tankId;

    public PacketDropperUse(BlockPos pos, DropperAction action, TankType tankType, int tankId) {
        this.pos = pos;
        this.action = action;
        this.tankType = tankType;
        this.tankId = tankId;
    }

    public static void handle(PacketDropperUse message, Supplier<NetworkEvent.Context> context) {
        PlayerEntity player = BasePacketHandler.getPlayer(context);
        if (player == null) {
            return;
        }
        context.get().enqueueWork(() -> {
            TileEntityMekanism tile;
            ItemStack stack = player.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper && (tile = MekanismUtils.getTileEntity(TileEntityMekanism.class, (IBlockReader)player.field_70170_p, message.pos)) != null) {
                IInfusionTank tank;
                if (tile instanceof TileEntityMultiblock) {
                    IInfusionTank tank2;
                    Object structure = ((TileEntityMultiblock)tile).structure;
                    if (message.tankType == TankType.GAS_TANK && structure instanceof IMekanismGasHandler) {
                        IGasTank tank3 = ((IMekanismGasHandler)structure).getGasTank(message.tankId, null);
                        if (tank3 != null) {
                            PacketDropperUse.handleChemicalTank(player, stack, tank3, message.action);
                        }
                    } else if (message.tankType == TankType.FLUID_TANK && structure instanceof IMekanismFluidHandler) {
                        IExtendedFluidTank tank4 = ((IMekanismFluidHandler)structure).getFluidTank(message.tankId, null);
                        if (tank4 != null) {
                            PacketDropperUse.handleFluidTank(player, stack, tank4, message.action);
                        }
                    } else if (message.tankType == TankType.INFUSION_TANK && structure instanceof IMekanismInfusionHandler && (tank2 = ((IMekanismInfusionHandler)structure).getInfusionTank(message.tankId, null)) != null) {
                        PacketDropperUse.handleChemicalTank(player, stack, tank2, message.action);
                    }
                } else if (message.tankType == TankType.GAS_TANK) {
                    IGasTank tank5 = tile.getGasTank(message.tankId, null);
                    if (tank5 != null) {
                        PacketDropperUse.handleChemicalTank(player, stack, tank5, message.action);
                    }
                } else if (message.tankType == TankType.FLUID_TANK) {
                    IExtendedFluidTank tank6 = tile.getFluidTank(message.tankId, null);
                    if (tank6 != null) {
                        PacketDropperUse.handleFluidTank(player, stack, tank6, message.action);
                    }
                } else if (message.tankType == TankType.INFUSION_TANK && (tank = tile.getInfusionTank(message.tankId, null)) != null) {
                    PacketDropperUse.handleChemicalTank(player, stack, tank, message.action);
                }
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void encode(PacketDropperUse pkt, PacketBuffer buf) {
        buf.func_179255_a(pkt.pos);
        buf.func_179249_a((Enum)pkt.action);
        buf.func_179249_a((Enum)pkt.tankType);
        buf.func_150787_b(pkt.tankId);
    }

    public static PacketDropperUse decode(PacketBuffer buf) {
        return new PacketDropperUse(buf.func_179259_c(), (DropperAction)buf.func_179257_a(DropperAction.class), (TankType)buf.func_179257_a(TankType.class), buf.func_150792_a());
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void handleChemicalTank(PlayerEntity player, ItemStack stack, IChemicalTank<CHEMICAL, STACK> chemicalTank, DropperAction action) {
        IInfusionHandler infusionHandler;
        Optional capability;
        if (action == DropperAction.DUMP_TANK) {
            chemicalTank.setEmpty();
            return;
        }
        IChemicalTank<Gas, GasStack> itemChemicalTank = null;
        STACK emptyStack = chemicalTank.getEmptyStack();
        if (emptyStack == GasStack.EMPTY) {
            IGasHandler gasHandlerItem;
            Optional capability2 = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
            if (capability2.isPresent() && (gasHandlerItem = (IGasHandler)capability2.get()) instanceof IMekanismGasHandler) {
                itemChemicalTank = ((IMekanismGasHandler)gasHandlerItem).getGasTank(0, null);
            }
        } else if (emptyStack == InfusionStack.EMPTY && (capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.INFUSION_HANDLER_CAPABILITY))).isPresent() && (infusionHandler = (IInfusionHandler)capability.get()) instanceof IMekanismInfusionHandler) {
            itemChemicalTank = ((IMekanismInfusionHandler)infusionHandler).getInfusionTank(0, null);
        }
        if (itemChemicalTank != null) {
            if (action == DropperAction.FILL_DROPPER) {
                PacketDropperUse.transferBetweenTanks(chemicalTank, itemChemicalTank, player);
            } else if (action == DropperAction.DRAIN_DROPPER) {
                PacketDropperUse.transferBetweenTanks(itemChemicalTank, chemicalTank, player);
            }
        }
    }

    private static void handleFluidTank(PlayerEntity player, ItemStack stack, IExtendedFluidTank fluidTank, DropperAction action) {
        IExtendedFluidTank itemFluidTank;
        IFluidHandlerItem fluidHandlerItem;
        if (action == DropperAction.DUMP_TANK) {
            fluidTank.setEmpty();
            return;
        }
        Optional capability = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)stack));
        if (capability.isPresent() && (fluidHandlerItem = (IFluidHandlerItem)capability.get()) instanceof IMekanismFluidHandler && (itemFluidTank = ((IMekanismFluidHandler)fluidHandlerItem).getFluidTank(0, null)) != null) {
            if (action == DropperAction.FILL_DROPPER) {
                PacketDropperUse.transferBetweenTanks(fluidTank, itemFluidTank, player);
            } else if (action == DropperAction.DRAIN_DROPPER) {
                PacketDropperUse.transferBetweenTanks(itemFluidTank, fluidTank, player);
            }
        }
    }

    private static <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void transferBetweenTanks(IChemicalTank<CHEMICAL, STACK> drainTank, IChemicalTank<CHEMICAL, STACK> fillTank, PlayerEntity player) {
        STACK extractedChemical;
        long amount;
        STACK chemicalInDrainTank;
        STACK simulatedRemainder;
        long remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0L && (remainder = ((ChemicalStack)(simulatedRemainder = fillTank.insert(chemicalInDrainTank = drainTank.getStack(), Action.SIMULATE, AutomationType.MANUAL))).getAmount()) < (amount = ((ChemicalStack)chemicalInDrainTank).getAmount()) && !((ChemicalStack)(extractedChemical = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL))).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(((ChemicalStack)fillTank.insert(extractedChemical, Action.EXECUTE, AutomationType.MANUAL)).getAmount(), 0L);
            ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
        }
    }

    private static void transferBetweenTanks(IExtendedFluidTank drainTank, IExtendedFluidTank fillTank, PlayerEntity player) {
        FluidStack extractedFluid;
        int amount;
        FluidStack fluidInDrainTank;
        FluidStack simulatedRemainder;
        int remainder;
        if (!drainTank.isEmpty() && fillTank.getNeeded() > 0 && (remainder = (simulatedRemainder = fillTank.insert(fluidInDrainTank = drainTank.getFluid(), Action.SIMULATE, AutomationType.MANUAL)).getAmount()) < (amount = fluidInDrainTank.getAmount()) && !(extractedFluid = drainTank.extract(amount - remainder, Action.EXECUTE, AutomationType.MANUAL)).isEmpty()) {
            MekanismUtils.logMismatchedStackSize(fillTank.insert(extractedFluid, Action.EXECUTE, AutomationType.MANUAL).getAmount(), 0L);
            ((ServerPlayerEntity)player).func_71120_a(player.field_71070_bA);
        }
    }

    public static enum TankType {
        GAS_TANK,
        FLUID_TANK,
        INFUSION_TANK;

    }

    public static enum DropperAction {
        FILL_DROPPER,
        DRAIN_DROPPER,
        DUMP_TANK;

    }
}

