/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item.gear;

import java.util.List;
import java.util.Optional;
import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.api.providers.IGasProvider;
import mekanism.client.render.armor.CustomArmor;
import mekanism.client.render.armor.ScubaTankArmor;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.capabilities.ItemCapabilityWrapper;
import mekanism.common.capabilities.chemical.item.RateLimitGasHandler;
import mekanism.common.item.gear.ISpecialGear;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StorageUtils;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public abstract class ItemGasArmor
extends ArmorItem
implements ISpecialGear {
    protected ItemGasArmor(IArmorMaterial material, EquipmentSlotType slot, Item.Properties properties) {
        super(material, slot, properties.setNoRepair().func_200917_a(1));
    }

    protected abstract LongSupplier getMaxGas();

    protected abstract LongSupplier getFillRate();

    protected abstract IGasProvider getGasType();

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        StorageUtils.addStoredGas(stack, tooltip, true);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return StorageUtils.getDurabilityForDisplay(stack);
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        GasStack stored = StorageUtils.getStoredGasFromNBT(stack);
        return stored.isEmpty() ? 0 : stored.getChemicalTint();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlotType slot, String type) {
        return "mekanism:render/null_armor.png";
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public CustomArmor getGearModel() {
        return ScubaTankArmor.SCUBA_TANK;
    }

    @Nonnull
    public GasStack useGas(ItemStack stack, long amount) {
        Optional capability = MekanismUtils.toOptional(stack.getCapability(Capabilities.GAS_HANDLER_CAPABILITY));
        if (capability.isPresent()) {
            IGasTank gasTank;
            IGasHandler gasHandlerItem = (IGasHandler)capability.get();
            if (gasHandlerItem instanceof IMekanismGasHandler && (gasTank = ((IMekanismGasHandler)gasHandlerItem).getGasTank(0, null)) != null) {
                return (GasStack)gasTank.extract(amount, Action.EXECUTE, AutomationType.MANUAL);
            }
            return gasHandlerItem.extractGas(amount, Action.EXECUTE);
        }
        return GasStack.EMPTY;
    }

    public void func_150895_a(@Nonnull ItemGroup group, @Nonnull NonNullList<ItemStack> items) {
        super.func_150895_a(group, items);
        if (this.func_194125_a(group)) {
            items.add((Object)GasUtils.getFilledVariant(new ItemStack((IItemProvider)this), this.getMaxGas().getAsLong(), this.getGasType()));
        }
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, CompoundNBT nbt) {
        return new ItemCapabilityWrapper(stack, RateLimitGasHandler.create(this.getFillRate(), this.getMaxGas(), (item, automationType) -> automationType != AutomationType.EXTERNAL, BasicGasTank.alwaysTrueBi, gas -> gas == this.getGasType().getGas()));
    }
}

