/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.slot;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.inventory.IInventorySlot;
import mekanism.api.inventory.IMekanismInventory;
import mekanism.common.base.ContainerEditMode;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.slot.BasicInventorySlot;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.StackUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class FluidInventorySlot
extends BasicInventorySlot {
    protected final IExtendedFluidTank fluidTank;
    private boolean isDraining;
    private boolean isFilling;

    public static FluidInventorySlot input(IExtendedFluidTank fluidTank, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, stack -> {
            Optional cap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)stack));
            if (cap.isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                boolean hasEmpty = false;
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) {
                        hasEmpty = true;
                        continue;
                    }
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
                if (fluidTank.isEmpty()) {
                    return hasEmpty;
                }
                return fluidHandlerItem.fill(fluidTank.getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0;
            }
            return false;
        }, stack -> FluidUtil.getFluidHandler((ItemStack)stack).isPresent(), inventory, x, y);
    }

    public static FluidInventorySlot rotary(IExtendedFluidTank fluidTank, BooleanSupplier modeSupplier, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        Objects.requireNonNull(modeSupplier, "Mode supplier cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, stack -> {
            Optional cap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)stack));
            if (cap.isPresent()) {
                boolean mode = modeSupplier.getAsBoolean();
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                boolean allEmpty = true;
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) continue;
                    if (fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() < fluidInTank.getAmount()) {
                        return mode;
                    }
                    allEmpty = false;
                }
                return allEmpty && !mode;
            }
            return false;
        }, stack -> {
            LazyOptional capability = FluidUtil.getFluidHandler((ItemStack)stack);
            if (capability.isPresent()) {
                if (modeSupplier.getAsBoolean()) {
                    IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)MekanismUtils.toOptional(capability).get();
                    for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                        FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                        if (fluidInTank.isEmpty() || !fluidTank.isFluidValid(fluidInTank)) continue;
                        return true;
                    }
                    return false;
                }
                return FluidInventorySlot.isNonFullFluidContainer((LazyOptional<IFluidHandlerItem>)capability);
            }
            return false;
        }, inventory, x, y);
    }

    public static FluidInventorySlot fill(IExtendedFluidTank fluidTank, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid tank cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, stack -> {
            Optional cap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)stack));
            if (cap.isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty() || fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    return true;
                }
            }
            return false;
        }, stack -> FluidUtil.getFluidHandler((ItemStack)stack).isPresent(), inventory, x, y);
    }

    public static FluidInventorySlot drain(IExtendedFluidTank fluidTank, @Nullable IMekanismInventory inventory, int x, int y) {
        Objects.requireNonNull(fluidTank, "Fluid handler cannot be null");
        return new FluidInventorySlot(fluidTank, alwaysFalse, stack -> {
            LazyOptional cap = FluidUtil.getFluidHandler((ItemStack)stack);
            if (cap.isPresent()) {
                FluidStack fluidInTank = fluidTank.getFluid();
                if (fluidInTank.isEmpty()) {
                    return true;
                }
                IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)MekanismUtils.toOptional(cap).get();
                if (itemFluidHandler.fill(fluidInTank, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    return true;
                }
            }
            return false;
        }, stack -> FluidInventorySlot.isNonFullFluidContainer((LazyOptional<IFluidHandlerItem>)FluidUtil.getFluidHandler((ItemStack)stack)), inventory, x, y);
    }

    private static boolean isNonFullFluidContainer(LazyOptional<IFluidHandlerItem> capability) {
        Optional<IFluidHandlerItem> cap = MekanismUtils.toOptional(capability);
        if (cap.isPresent()) {
            IFluidHandlerItem fluidHandler = cap.get();
            for (int tank = 0; tank < fluidHandler.getTanks(); ++tank) {
                if (fluidHandler.getFluidInTank(tank).getAmount() >= fluidHandler.getTankCapacity(tank)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected FluidInventorySlot(IExtendedFluidTank fluidTank, Predicate<@NonNull ItemStack> canExtract, Predicate<@NonNull ItemStack> canInsert, Predicate<@NonNull ItemStack> validator, @Nullable IMekanismInventory inventory, int x, int y) {
        super(canExtract, canInsert, validator, inventory, x, y);
        this.setSlotType(ContainerSlotType.EXTRA);
        this.fluidTank = fluidTank;
    }

    @Override
    public void setStack(ItemStack stack) {
        super.setStack(stack);
        this.isDraining = false;
        this.isFilling = false;
    }

    public void handleTank(IInventorySlot outputSlot, ContainerEditMode editMode) {
        if (!this.isEmpty()) {
            Optional cap;
            if (editMode == ContainerEditMode.FILL) {
                this.drainTank(outputSlot);
            } else if (editMode == ContainerEditMode.EMPTY) {
                this.fillTank(outputSlot);
            } else if (editMode == ContainerEditMode.BOTH && (cap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)this.current))).isPresent()) {
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                boolean hasEmpty = false;
                for (int tank = 0; tank < fluidHandlerItem.getTanks(); ++tank) {
                    FluidStack fluidInTank = fluidHandlerItem.getFluidInTank(tank);
                    if (fluidInTank.isEmpty()) {
                        hasEmpty = true;
                        continue;
                    }
                    if (this.isDraining || this.fluidTank.insert(fluidInTank, Action.SIMULATE, AutomationType.INTERNAL).getAmount() >= fluidInTank.getAmount()) continue;
                    this.fillTank(outputSlot);
                    return;
                }
                if (this.isFilling) {
                    if (this.moveItem(outputSlot, this.current)) {
                        this.isFilling = false;
                    }
                } else if (this.fluidTank.isEmpty() && hasEmpty || this.isDraining || fluidHandlerItem.fill(this.fluidTank.getFluid(), IFluidHandler.FluidAction.SIMULATE) > 0) {
                    this.drainTank(outputSlot);
                }
            }
        }
    }

    public void fillTank(IInventorySlot outputSlot) {
        block4: {
            int itemTanks;
            IFluidHandlerItem itemFluidHandler;
            block5: {
                Optional capability;
                if (this.isEmpty() || !(capability = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)this.current))).isPresent()) break block4;
                itemFluidHandler = (IFluidHandlerItem)capability.get();
                itemTanks = itemFluidHandler.getTanks();
                if (itemTanks != 1) break block5;
                FluidStack fluidInItem = itemFluidHandler.getFluidInTank(0);
                if (fluidInItem.isEmpty() || !this.fluidTank.isFluidValid(fluidInItem)) break block4;
                this.drainItemAndMove(outputSlot, fluidInItem);
                break block4;
            }
            if (itemTanks > 1) {
                FluidStack knownFluid;
                Object2ObjectOpenHashMap knownFluids = new Object2ObjectOpenHashMap();
                for (int itemTank = 0; itemTank < itemTanks; ++itemTank) {
                    FluidStack fluidInItem = itemFluidHandler.getFluidInTank(itemTank);
                    if (fluidInItem.isEmpty()) continue;
                    FluidInfo info = new FluidInfo(fluidInItem);
                    FluidStack knownFluid2 = (FluidStack)knownFluids.get(info);
                    if (knownFluid2 == null) {
                        if (itemFluidHandler.drain(fluidInItem, IFluidHandler.FluidAction.SIMULATE).isEmpty() || !this.fluidTank.isFluidValid(fluidInItem)) continue;
                        knownFluids.put(info, fluidInItem.copy());
                        continue;
                    }
                    knownFluid2.grow(fluidInItem.getAmount());
                }
                Iterator iterator = knownFluids.values().iterator();
                while (!(!iterator.hasNext() || this.drainItemAndMove(outputSlot, knownFluid = (FluidStack)iterator.next()) && this.isEmpty())) {
                }
            }
        }
    }

    public void drainTank(IInventorySlot outputSlot) {
        FluidStack fluidInTank;
        if (!this.isEmpty() && FluidUtil.getFluidHandler((ItemStack)this.current).isPresent() && !(fluidInTank = this.fluidTank.getFluid()).isEmpty()) {
            FluidStack simulatedDrain = this.fluidTank.extract(fluidInTank.getAmount(), Action.SIMULATE, AutomationType.INTERNAL);
            if (simulatedDrain.isEmpty()) {
                return;
            }
            ItemStack inputCopy = StackUtils.size(this.current, 1);
            Optional cap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)inputCopy));
            if (cap.isPresent()) {
                Optional containerCap;
                IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
                int toDrain = fluidHandlerItem.fill(fluidInTank, IFluidHandler.FluidAction.EXECUTE);
                if (this.getCount() == 1 && (containerCap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)fluidHandlerItem.getContainer()))).isPresent() && ((IFluidHandlerItem)containerCap.get()).fill(fluidInTank, IFluidHandler.FluidAction.SIMULATE) > 0) {
                    this.setStack(fluidHandlerItem.getContainer());
                    this.isDraining = true;
                    MekanismUtils.logMismatchedStackSize(this.fluidTank.shrinkStack(toDrain, Action.EXECUTE), toDrain);
                    return;
                }
                if (this.moveItem(outputSlot, fluidHandlerItem.getContainer())) {
                    MekanismUtils.logMismatchedStackSize(this.fluidTank.shrinkStack(toDrain, Action.EXECUTE), toDrain);
                    this.isDraining = false;
                }
            }
        }
    }

    private boolean drainItemAndMove(IInventorySlot outputSlot, FluidStack fluidToTransfer) {
        Optional containerCap;
        int toTransfer;
        FluidStack simulatedRemainder = this.fluidTank.insert(fluidToTransfer, Action.SIMULATE, AutomationType.INTERNAL);
        int remainder = simulatedRemainder.getAmount();
        if (remainder == (toTransfer = fluidToTransfer.getAmount())) {
            return false;
        }
        ItemStack input = StackUtils.size(this.current, 1);
        Optional cap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)input));
        if (!cap.isPresent()) {
            return false;
        }
        IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)cap.get();
        FluidStack drained = fluidHandlerItem.drain(new FluidStack(fluidToTransfer, toTransfer - remainder), IFluidHandler.FluidAction.EXECUTE);
        if (drained.isEmpty()) {
            return false;
        }
        if (this.getCount() == 1 && (containerCap = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)fluidHandlerItem.getContainer()))).isPresent() && !((IFluidHandlerItem)containerCap.get()).drain(Integer.MAX_VALUE, IFluidHandler.FluidAction.SIMULATE).isEmpty()) {
            this.setStack(fluidHandlerItem.getContainer());
            this.fluidTank.insert(drained, Action.EXECUTE, AutomationType.INTERNAL);
            this.isFilling = true;
            return true;
        }
        if (this.moveItem(outputSlot, fluidHandlerItem.getContainer())) {
            this.fluidTank.insert(drained, Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }

    private boolean moveItem(IInventorySlot outputSlot, ItemStack stackToMove) {
        if (outputSlot.isEmpty()) {
            outputSlot.setStack(stackToMove);
        } else {
            ItemStack outputStack = outputSlot.getStack();
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)outputStack, (ItemStack)stackToMove) || outputStack.func_190916_E() >= outputSlot.getLimit(outputStack)) {
                return false;
            }
            MekanismUtils.logMismatchedStackSize(outputSlot.growStack(1, Action.EXECUTE), 1L);
        }
        MekanismUtils.logMismatchedStackSize(this.shrinkStack(1, Action.EXECUTE), 1L);
        return true;
    }

    public boolean fillTank() {
        Optional capability;
        if (this.getCount() == 1 && (capability = MekanismUtils.toOptional(FluidUtil.getFluidHandler((ItemStack)this.current))).isPresent()) {
            IFluidHandlerItem itemFluidHandler = (IFluidHandlerItem)capability.get();
            int tanks = itemFluidHandler.getTanks();
            if (tanks == 1) {
                FluidStack fluidInItem = itemFluidHandler.getFluidInTank(0);
                if (!fluidInItem.isEmpty() && this.fluidTank.isFluidValid(fluidInItem) && this.fillHandlerFromOther(this.fluidTank, (IFluidHandler)itemFluidHandler, fluidInItem)) {
                    this.setStack(itemFluidHandler.getContainer());
                    return true;
                }
            } else if (tanks > 1) {
                Object2ObjectOpenHashMap knownFluids = new Object2ObjectOpenHashMap();
                for (int tank = 0; tank < tanks; ++tank) {
                    FluidStack fluidInItem = itemFluidHandler.getFluidInTank(tank);
                    if (fluidInItem.isEmpty()) continue;
                    FluidInfo info = new FluidInfo(fluidInItem);
                    FluidStack knownFluid = (FluidStack)knownFluids.get(info);
                    if (knownFluid == null) {
                        if (itemFluidHandler.drain(fluidInItem, IFluidHandler.FluidAction.SIMULATE).isEmpty() || !this.fluidTank.isFluidValid(fluidInItem)) continue;
                        knownFluids.put(info, fluidInItem.copy());
                        continue;
                    }
                    knownFluid.grow(fluidInItem.getAmount());
                }
                if (!knownFluids.isEmpty()) {
                    boolean changed = false;
                    for (FluidStack knownFluid : knownFluids.values()) {
                        if (!this.fillHandlerFromOther(this.fluidTank, (IFluidHandler)itemFluidHandler, knownFluid)) continue;
                        changed = true;
                    }
                    if (changed) {
                        this.setStack(itemFluidHandler.getContainer());
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean fillHandlerFromOther(IExtendedFluidTank handlerToFill, IFluidHandler handlerToDrain, FluidStack fluid) {
        int drained;
        FluidStack simulatedRemainder;
        int remainder;
        FluidStack simulatedDrain = handlerToDrain.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
        if (!simulatedDrain.isEmpty() && (remainder = (simulatedRemainder = this.fluidTank.insert(simulatedDrain, Action.SIMULATE, AutomationType.INTERNAL)).getAmount()) < (drained = simulatedDrain.getAmount())) {
            handlerToFill.insert(handlerToDrain.drain(new FluidStack(fluid, drained - remainder), IFluidHandler.FluidAction.EXECUTE), Action.EXECUTE, AutomationType.INTERNAL);
            return true;
        }
        return false;
    }

    private static class FluidInfo {
        private final FluidStack fluidStack;

        public FluidInfo(FluidStack fluidStack) {
            this.fluidStack = fluidStack;
        }

        public boolean equals(Object other) {
            return other == this || other instanceof FluidInfo && this.fluidStack.isFluidEqual(((FluidInfo)other).fluidStack);
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.fluidStack.getFluid().hashCode();
            if (this.fluidStack.hasTag()) {
                code = 31 * code + this.fluidStack.getTag().hashCode();
            }
            return code;
        }
    }
}

