/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.tile;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.inventory.IInventorySlot;
import mekanism.common.inventory.container.IEmptyContainer;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.registration.impl.ContainerTypeRegistryObject;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class MekanismTileContainer<TILE extends TileEntityMekanism>
extends MekanismContainer {
    @Nullable
    protected final TILE tile;

    public MekanismTileContainer(ContainerTypeRegistryObject<?> type, int id, @Nullable PlayerInventory inv, @Nullable TILE tile) {
        super(type, id, inv);
        this.tile = tile;
        this.addContainerTrackers();
        this.addSlotsAndOpen();
    }

    protected void addContainerTrackers() {
        if (this.tile != null) {
            ((TileEntityMekanism)this.tile).addContainerTrackers(this);
        }
    }

    public TILE getTileEntity() {
        return this.tile;
    }

    @Override
    protected void openInventory(@Nonnull PlayerInventory inv) {
        if (this.tile != null) {
            ((TileEntityMekanism)this.tile).open(inv.field_70458_d);
        }
    }

    @Override
    protected void closeInventory(PlayerEntity player) {
        if (this.tile != null) {
            ((TileEntityMekanism)this.tile).close(player);
        }
    }

    @Override
    public boolean func_75145_c(@Nonnull PlayerEntity player) {
        if (this.tile == null) {
            return true;
        }
        if (((TileEntityMekanism)this.tile).hasGui() && !this.tile.func_145837_r()) {
            World world = this.tile.func_145831_w();
            if (world == null) {
                return false;
            }
            return world.func_195588_v(this.tile.func_174877_v());
        }
        return false;
    }

    @Override
    protected void addSlots() {
        super.addSlots();
        if (this instanceof IEmptyContainer) {
            return;
        }
        if (this.tile != null && ((TileEntityMekanism)this.tile).hasInventory()) {
            List<IInventorySlot> inventorySlots = ((TileEntityMekanism)this.tile).getInventorySlots(null);
            for (IInventorySlot inventorySlot : inventorySlots) {
                Slot containerSlot = inventorySlot.createContainerSlot();
                if (containerSlot == null) continue;
                this.func_75146_a(containerSlot);
            }
        }
    }

    public static <TILE extends TileEntity> TILE getTileFromBuf(PacketBuffer buf, Class<TILE> type) {
        if (buf == null) {
            return null;
        }
        return (TILE)((TileEntity)DistExecutor.callWhenOn((Dist)Dist.CLIENT, () -> () -> MekanismUtils.getTileEntity(type, (IBlockReader)Minecraft.func_71410_x().field_71441_e, buf.func_179259_c())));
    }
}

