/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.inventory.container.sync;

import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.common.inventory.container.sync.ISyncableData;

public abstract class SyncableChemicalStack<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements ISyncableData {
    @Nonnull
    private ChemicalStack<CHEMICAL> lastKnownValue;
    private final Supplier<@NonNull STACK> getter;
    private final Consumer<@NonNull STACK> setter;

    protected SyncableChemicalStack(Supplier<@NonNull STACK> getter, Consumer<@NonNull STACK> setter) {
        this.getter = getter;
        this.setter = setter;
        this.lastKnownValue = this.getEmptyStack();
    }

    @Nonnull
    protected abstract STACK getEmptyStack();

    @Nonnull
    protected abstract STACK createStack(STACK var1, long var2);

    @Nonnull
    public STACK get() {
        return (STACK)((ChemicalStack)this.getter.get());
    }

    public void set(@Nonnull STACK value) {
        this.setter.accept(value);
    }

    public void set(long amount) {
        STACK stack = this.get();
        if (!((ChemicalStack)stack).isEmpty()) {
            this.set(this.createStack(stack, amount));
        }
    }

    @Override
    public ISyncableData.DirtyType isDirty() {
        STACK value = this.get();
        boolean sameType = ((ChemicalStack)value).isTypeEqual(this.lastKnownValue);
        if (!sameType || ((ChemicalStack)value).getAmount() != this.lastKnownValue.getAmount()) {
            this.lastKnownValue = ((ChemicalStack)value).copy();
            return sameType ? ISyncableData.DirtyType.SIZE : ISyncableData.DirtyType.DIRTY;
        }
        return ISyncableData.DirtyType.CLEAN;
    }
}

