/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.theoneprobe;

import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IElement;
import mcjty.theoneprobe.api.IElementNew;
import mcjty.theoneprobe.api.IProbeConfig;
import mcjty.theoneprobe.api.IProbeConfigProvider;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import mcjty.theoneprobe.api.TextStyleClass;
import mekanism.api.Coord4D;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandlerWrapper;
import mekanism.api.chemical.gas.GasHandlerWrapper;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.IMekanismInfusionHandler;
import mekanism.api.chemical.infuse.InfusionHandlerWrapper;
import mekanism.api.energy.IMekanismStrictEnergyHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.fluid.IMekanismFluidHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.integration.theoneprobe.EnergyElement;
import mekanism.common.integration.theoneprobe.FluidElement;
import mekanism.common.integration.theoneprobe.GasElement;
import mekanism.common.integration.theoneprobe.InfuseTypeElement;
import mekanism.common.integration.theoneprobe.ProbeConfigProvider;
import mekanism.common.multiblock.IStructuralMultiblock;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.base.TileEntityUpdateable;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TOPProvider
implements IProbeInfoProvider,
Function<ITheOneProbe, Void> {
    private boolean displayFluidTanks;
    private IProbeConfig.ConfigMode tankMode = IProbeConfig.ConfigMode.EXTENDED;

    @Override
    public Void apply(ITheOneProbe probe) {
        probe.registerProvider((IProbeInfoProvider)this);
        probe.registerProbeConfigProvider((IProbeConfigProvider)ProbeConfigProvider.INSTANCE);
        EnergyElement.ID = probe.registerElementFactory(EnergyElement::new);
        FluidElement.ID = probe.registerElementFactory(FluidElement::new);
        GasElement.ID = probe.registerElementFactory(GasElement::new);
        InfuseTypeElement.ID = probe.registerElementFactory(InfuseTypeElement::new);
        IProbeConfig probeConfig = probe.createProbeConfig();
        this.displayFluidTanks = probeConfig.getTankMode() > 0;
        this.tankMode = probeConfig.getShowTankSetting();
        return null;
    }

    public String getID() {
        return Mekanism.rl("chemicals").toString();
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo info, PlayerEntity player, World world, BlockState blockState, IProbeHitData data) {
        TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, data.getPos());
        if (tile != null) {
            ProbeMode requiredMode;
            SynchronizedData<?> structure = this.getStructure(tile);
            Optional<IStrictEnergyHandler> energyCapability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.STRICT_ENERGY_CAPABILITY, null));
            if (energyCapability.isPresent()) {
                this.displayEnergy(info, energyCapability.get());
            } else if (structure instanceof IMekanismStrictEnergyHandler) {
                this.displayEnergy(info, (IMekanismStrictEnergyHandler)((Object)structure));
            }
            if (this.tankMode == IProbeConfig.ConfigMode.NOT) {
                return;
            }
            ProbeMode probeMode = requiredMode = this.tankMode == IProbeConfig.ConfigMode.NORMAL ? ProbeMode.NORMAL : ProbeMode.EXTENDED;
            if (mode == requiredMode) {
                Optional<IGasHandler> gasCapability;
                if (this.displayFluidTanks && tile instanceof TileEntityUpdateable) {
                    Optional fluidCapability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null));
                    if (fluidCapability.isPresent()) {
                        this.displayFluid(info, (IFluidHandler)fluidCapability.get());
                    } else if (structure instanceof IMekanismFluidHandler) {
                        this.displayFluid(info, (IMekanismFluidHandler)((Object)structure));
                    }
                }
                if ((gasCapability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.GAS_HANDLER_CAPABILITY, null))).isPresent()) {
                    this.addInfo(new GasHandlerWrapper(gasCapability.get()), info, GasElement::new, MekanismLang.GAS);
                } else if (structure instanceof IMekanismGasHandler) {
                    this.addInfo(new GasHandlerWrapper((IMekanismGasHandler)((Object)structure)), info, GasElement::new, MekanismLang.GAS);
                }
                Optional<IInfusionHandler> infusionCapability = MekanismUtils.toOptional(CapabilityUtils.getCapability((ICapabilityProvider)tile, Capabilities.INFUSION_HANDLER_CAPABILITY, null));
                if (infusionCapability.isPresent()) {
                    this.addInfo(new InfusionHandlerWrapper(infusionCapability.get()), info, InfuseTypeElement::new, MekanismLang.INFUSE_TYPE);
                } else if (structure instanceof IMekanismInfusionHandler) {
                    this.addInfo(new InfusionHandlerWrapper((IMekanismInfusionHandler)((Object)structure)), info, InfuseTypeElement::new, MekanismLang.INFUSE_TYPE);
                }
            }
        }
    }

    @Nullable
    private SynchronizedData<?> getStructure(@Nonnull TileEntity tile) {
        TileEntity tileEntity;
        IStructuralMultiblock structuralMultiblock;
        Coord4D controller;
        if (tile instanceof TileEntityMultiblock) {
            return ((TileEntityMultiblock)tile).structure;
        }
        if (tile instanceof IStructuralMultiblock && (controller = (structuralMultiblock = (IStructuralMultiblock)tile).getController()) != null && (tileEntity = MekanismUtils.getTileEntity((IBlockReader)tile.func_145831_w(), controller.getPos())) instanceof TileEntityMultiblock) {
            return ((TileEntityMultiblock)tileEntity).structure;
        }
        return null;
    }

    private void displayFluid(IProbeInfo info, IFluidHandler fluidHandler) {
        int tanks = fluidHandler.getTanks();
        for (int tank = 0; tank < tanks; ++tank) {
            FluidStack fluidInTank = fluidHandler.getFluidInTank(tank);
            if (!fluidInTank.isEmpty()) {
                info.text(TextStyleClass.NAME + MekanismLang.LIQUID.translate(fluidInTank).func_150254_d());
            }
            info.element((IElement)new FluidElement(fluidInTank, fluidHandler.getTankCapacity(tank)));
        }
    }

    private void displayEnergy(IProbeInfo info, IStrictEnergyHandler energyHandler) {
        int containers = energyHandler.getEnergyContainerCount();
        for (int container = 0; container < containers; ++container) {
            info.element((IElement)new EnergyElement(energyHandler.getEnergy(container), energyHandler.getMaxEnergy(container)));
        }
    }

    private <CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> void addInfo(IChemicalHandlerWrapper<CHEMICAL, STACK> wrapper, IProbeInfo info, ElementCreator<CHEMICAL, STACK> elementCreator, ILangEntry langEntry) {
        for (int i = 0; i < wrapper.getTanks(); ++i) {
            STACK chemicalInTank = wrapper.getChemicalInTank(i);
            if (!((ChemicalStack)chemicalInTank).isEmpty()) {
                info.text(TextStyleClass.NAME + langEntry.translate(((ChemicalStack)chemicalInTank).getType()).func_150254_d());
            }
            info.element((IElement)elementCreator.create(chemicalInTank, wrapper.getTankCapacity(i)));
        }
    }

    @FunctionalInterface
    private static interface ElementCreator<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>> {
        public IElementNew create(STACK var1, long var2);
    }
}

