/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.integration.projecte.NSSGas;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;

@RecipeTypeMapper
public class ItemStackGasToItemStackRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekItemStackGasToItemStack";
    }

    public String getDescription() {
        return "Maps Mekanism Machine recipes that go from item, gas to item. (Compressing, Purifying, Injecting)";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.COMPRESSING || recipeType == MekanismRecipeType.PURIFYING || recipeType == MekanismRecipeType.INJECTING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe) {
        if (!(iRecipe instanceof ItemStackGasToItemStackRecipe)) {
            return false;
        }
        boolean handled = false;
        ItemStackGasToItemStackRecipe recipe = (ItemStackGasToItemStackRecipe)iRecipe;
        List<@NonNull TYPE> itemRepresentations = recipe.getItemInput().getRepresentations();
        List<@NonNull TYPE> gasRepresentations = recipe.getGasInput().getRepresentations();
        long gasMultiplier = 200L;
        for (GasStack gasRepresentation : gasRepresentations) {
            NSSGas nssGas = NSSGas.createGas(gasRepresentation);
            long gasAmount = gasRepresentation.getAmount() * gasMultiplier;
            for (ItemStack itemRepresentation : itemRepresentations) {
                ItemStack output = recipe.getOutput(itemRepresentation, gasRepresentation);
                if (output.func_190926_b()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put(itemRepresentation);
                ingredientHelper.put((NormalizedSimpleStack)nssGas, gasAmount);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

