/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.projecte.mappers;

import java.util.List;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.FluidGasToGasRecipe;
import mekanism.common.integration.projecte.IngredientHelper;
import mekanism.common.recipe.MekanismRecipeType;
import moze_intel.projecte.api.mapper.collector.IMappingCollector;
import moze_intel.projecte.api.mapper.recipe.IRecipeTypeMapper;
import moze_intel.projecte.api.mapper.recipe.RecipeTypeMapper;
import moze_intel.projecte.api.nss.NSSFluid;
import moze_intel.projecte.api.nss.NormalizedSimpleStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraftforge.fluids.FluidStack;

@RecipeTypeMapper
public class FluidGasToGasRecipeMapper
implements IRecipeTypeMapper {
    public String getName() {
        return "MekFluidGasToGas";
    }

    public String getDescription() {
        return "Maps Mekanism washing recipes.";
    }

    public boolean canHandle(IRecipeType<?> recipeType) {
        return recipeType == MekanismRecipeType.WASHING;
    }

    public boolean handleRecipe(IMappingCollector<NormalizedSimpleStack, Long> mapper, IRecipe<?> iRecipe) {
        if (!(iRecipe instanceof FluidGasToGasRecipe)) {
            return false;
        }
        boolean handled = false;
        FluidGasToGasRecipe recipe = (FluidGasToGasRecipe)iRecipe;
        List<@NonNull TYPE> fluidRepresentations = recipe.getFluidInput().getRepresentations();
        List<@NonNull TYPE> gasRepresentations = recipe.getGasInput().getRepresentations();
        for (FluidStack fluidRepresentation : fluidRepresentations) {
            NSSFluid nssFluid = NSSFluid.createFluid((FluidStack)fluidRepresentation);
            for (GasStack gasRepresentation : gasRepresentations) {
                GasStack output = recipe.getOutput(fluidRepresentation, gasRepresentation);
                if (output.isEmpty()) continue;
                IngredientHelper ingredientHelper = new IngredientHelper(mapper);
                ingredientHelper.put((NormalizedSimpleStack)nssFluid, fluidRepresentation.getAmount());
                ingredientHelper.put(gasRepresentation);
                if (!ingredientHelper.addAsConversion(output)) continue;
                handled = true;
            }
        }
        return handled;
    }
}

