/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.energy.fluxnetworks;

import mekanism.api.Action;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.common.integration.energy.EnergyCompatUtils;
import sonar.fluxnetworks.api.energy.IFNEnergyStorage;

public class FNIntegration
implements IFNEnergyStorage {
    private final IStrictEnergyHandler handler;

    public FNIntegration(IStrictEnergyHandler handler) {
        this.handler = handler;
    }

    public long receiveEnergyL(long maxReceive, boolean simulate) {
        if (maxReceive <= 0L) {
            return 0L;
        }
        FloatingLong toInsert = EnergyCompatUtils.EnergyType.FORGE.convertFrom(maxReceive);
        return EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(toInsert.subtract(this.handler.insertEnergy(toInsert, Action.get(!simulate))));
    }

    public long extractEnergyL(long maxExtract, boolean simulate) {
        return maxExtract <= 0L ? 0L : EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.handler.extractEnergy(EnergyCompatUtils.EnergyType.FORGE.convertFrom(maxExtract), Action.get(!simulate)));
    }

    public long getEnergyStoredL() {
        int containers = this.handler.getEnergyContainerCount();
        if (containers > 0) {
            long energy = 0L;
            for (int container = 0; container < containers; ++container) {
                long total = EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.handler.getEnergy(container));
                if (total > Long.MAX_VALUE - energy) {
                    energy = Long.MAX_VALUE;
                    break;
                }
                energy += total;
            }
            return energy;
        }
        return 0L;
    }

    public long getMaxEnergyStoredL() {
        int containers = this.handler.getEnergyContainerCount();
        if (containers > 0) {
            long maxEnergy = 0L;
            for (int container = 0; container < containers; ++container) {
                long max = EnergyCompatUtils.EnergyType.FORGE.convertToAsLong(this.handler.getMaxEnergy(container));
                if (max > Long.MAX_VALUE - maxEnergy) {
                    maxEnergy = Long.MAX_VALUE;
                    break;
                }
                maxEnergy += max;
            }
            return maxEnergy;
        }
        return 0L;
    }

    public boolean canExtractL() {
        return !this.handler.extractEnergy(FloatingLong.ONE, Action.SIMULATE).isZero();
    }

    public boolean canReceiveL() {
        return this.handler.insertEnergy(FloatingLong.ONE, Action.SIMULATE).smallerThan(FloatingLong.ONE);
    }
}

