/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.frequency;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.HashList;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyType;
import mekanism.common.frequency.IFrequencyHandler;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class FrequencyManager {
    public static final int MAX_FREQ_LENGTH = 16;
    public static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('-'), Character.valueOf(' '), Character.valueOf('|'), Character.valueOf('\''), Character.valueOf('\"'), Character.valueOf('_'), Character.valueOf('+'), Character.valueOf(':'), Character.valueOf('('), Character.valueOf(')'), Character.valueOf('?'), Character.valueOf('!'), Character.valueOf('/'), Character.valueOf('@'), Character.valueOf('$'), Character.valueOf('`'), Character.valueOf('~'), Character.valueOf(','), Character.valueOf('.'), Character.valueOf('#'));
    public static boolean loaded;
    private static Set<FrequencyManager> managers;
    private List<Frequency> frequencies = new HashList<Frequency>();
    @Nullable
    private FrequencyDataHandler dataHandler;
    private UUID ownerUUID;
    private String name;
    private final FrequencyType frequencyType;

    public FrequencyManager(FrequencyType frequencyType, String name) {
        this.frequencyType = frequencyType;
        this.name = name;
        managers.add(this);
    }

    public FrequencyManager(FrequencyType frequencyType, String name, UUID uuid) {
        this(frequencyType, name);
        this.ownerUUID = uuid;
    }

    public static void load() {
        loaded = true;
        for (FrequencyManager manager : managers) {
            manager.createOrLoad();
        }
    }

    public static void tick(World world) {
        if (!loaded && !world.func_201670_d()) {
            FrequencyManager.load();
        }
        for (FrequencyManager manager : managers) {
            manager.tickSelf(world);
        }
    }

    public static void reset() {
        for (FrequencyManager manager : managers) {
            manager.frequencies.clear();
            manager.dataHandler = null;
        }
        loaded = false;
    }

    public Frequency update(Coord4D coord, Frequency freq) {
        for (Frequency iterFreq : this.getFrequencies()) {
            if (!freq.equals(iterFreq)) continue;
            iterFreq.activeCoords.add(coord);
            if (this.dataHandler != null) {
                this.dataHandler.func_76185_a();
            }
            return iterFreq;
        }
        this.deactivate(coord);
        return null;
    }

    public void remove(String name, UUID owner) {
        Iterator<Frequency> iter = this.getFrequencies().iterator();
        while (iter.hasNext()) {
            Frequency iterFreq = iter.next();
            if (!iterFreq.name.equals(name) || !iterFreq.ownerUUID.equals(owner)) continue;
            iter.remove();
            if (this.dataHandler == null) continue;
            this.dataHandler.func_76185_a();
        }
    }

    public void remove(String name) {
        Iterator<Frequency> iter = this.getFrequencies().iterator();
        while (iter.hasNext()) {
            Frequency iterFreq = iter.next();
            if (!iterFreq.name.equals(name)) continue;
            iter.remove();
            if (this.dataHandler == null) continue;
            this.dataHandler.func_76185_a();
        }
    }

    public void deactivate(Coord4D coord) {
        for (Frequency freq : this.getFrequencies()) {
            freq.activeCoords.remove(coord);
            if (this.dataHandler == null) continue;
            this.dataHandler.func_76185_a();
        }
    }

    public Frequency validateFrequency(UUID uuid, Coord4D coord, Frequency freq) {
        for (Frequency iterFreq : this.getFrequencies()) {
            if (!freq.equals(iterFreq)) continue;
            iterFreq.activeCoords.add(coord);
            if (this.dataHandler != null) {
                this.dataHandler.func_76185_a();
            }
            return iterFreq;
        }
        if (uuid.equals(freq.ownerUUID)) {
            freq.activeCoords.add(coord);
            freq.valid = true;
            this.addFrequency(freq);
            return freq;
        }
        return null;
    }

    public void createOrLoad() {
        if (this.dataHandler == null) {
            String name = this.getName();
            DimensionSavedDataManager savedData = ServerLifecycleHooks.getCurrentServer().func_71218_a(DimensionType.field_223227_a_).func_217481_x();
            this.dataHandler = (FrequencyDataHandler)savedData.func_215752_a(() -> new FrequencyDataHandler(name), name);
            this.dataHandler.setManager(this);
            this.dataHandler.syncManager();
        }
    }

    public List<Frequency> getFrequencies() {
        return this.frequencies;
    }

    public void addFrequency(Frequency freq) {
        this.frequencies.add(freq);
        if (this.dataHandler != null) {
            this.dataHandler.func_76185_a();
        }
    }

    public boolean containsFrequency(String name) {
        for (Frequency freq : this.getFrequencies()) {
            if (!freq.name.equals(name)) continue;
            return true;
        }
        return false;
    }

    private void tickSelf(World world) {
        for (Frequency iterFreq : this.getFrequencies()) {
            Iterator<Coord4D> iter = iterFreq.activeCoords.iterator();
            while (iter.hasNext()) {
                Coord4D coord = iter.next();
                if (!coord.dimension.equals(world.func_201675_m().func_186058_p())) continue;
                TileEntity tile = MekanismUtils.getTileEntity((IBlockReader)world, coord.getPos());
                if (tile instanceof IFrequencyHandler) {
                    Frequency freq = ((IFrequencyHandler)tile).getFrequency(this);
                    if (freq != null && freq.equals(iterFreq)) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
        }
    }

    public String getName() {
        return this.ownerUUID != null ? this.ownerUUID.toString() + "_" + this.name + "FrequencyHandler" : this.name + "FrequencyHandler";
    }

    static {
        managers = new ObjectOpenHashSet();
    }

    public static class FrequencyDataHandler
    extends WorldSavedData {
        public FrequencyManager manager;
        public List<Frequency> loadedFrequencies;
        public UUID loadedOwner;

        public FrequencyDataHandler(String tagName) {
            super(tagName);
        }

        public void setManager(FrequencyManager m) {
            this.manager = m;
        }

        public void syncManager() {
            if (this.loadedFrequencies != null) {
                this.manager.frequencies = this.loadedFrequencies;
                this.manager.ownerUUID = this.loadedOwner;
            }
        }

        public void func_76184_a(@Nonnull CompoundNBT nbtTags) {
            NBTUtils.setUUIDIfPresent(nbtTags, "owner", uuid -> {
                this.loadedOwner = uuid;
            });
            if (nbtTags.func_150297_b("type", 3)) {
                Function<CompoundNBT, Frequency> creatorFunction;
                FrequencyType type = FrequencyType.byIndexStatic(nbtTags.func_74762_e("type"));
                switch (type) {
                    case INVENTORY: {
                        creatorFunction = nbt -> new InventoryFrequency((CompoundNBT)nbt, false);
                        break;
                    }
                    case SECURITY: {
                        creatorFunction = nbt -> new SecurityFrequency((CompoundNBT)nbt, false);
                        break;
                    }
                    default: {
                        creatorFunction = nbt -> new Frequency((CompoundNBT)nbt, false);
                    }
                }
                ListNBT list = nbtTags.func_150295_c("freqList", 10);
                this.loadedFrequencies = new HashList<Frequency>();
                for (int i = 0; i < list.size(); ++i) {
                    this.loadedFrequencies.add(creatorFunction.apply(list.func_150305_b(i)));
                }
            }
        }

        @Nonnull
        public CompoundNBT func_189551_b(@Nonnull CompoundNBT nbtTags) {
            nbtTags.func_74768_a("type", this.manager.frequencyType.ordinal());
            if (this.manager.ownerUUID != null) {
                nbtTags.func_186854_a("owner", this.manager.ownerUUID);
            }
            ListNBT list = new ListNBT();
            for (Frequency freq : this.manager.getFrequencies()) {
                CompoundNBT compound = new CompoundNBT();
                freq.write(compound);
                list.add((Object)compound);
            }
            nbtTags.func_218657_a("freqList", (INBT)list);
            return nbtTags;
        }
    }
}

