/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.BasicGasTank;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.inventory.AutomationType;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class VariableCapacityGasTank
extends BasicGasTank {
    private final LongSupplier capacity;

    public static VariableCapacityGasTank create(LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> validator, @Nullable IMekanismGasHandler gasHandler) {
        return VariableCapacityGasTank.create(capacity, canExtract, canInsert, validator, null, gasHandler);
    }

    public static VariableCapacityGasTank create(LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IMekanismGasHandler gasHandler) {
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        Objects.requireNonNull(validator, "Gas validity check cannot be null");
        return new VariableCapacityGasTank(capacity, canExtract, canInsert, validator, attributeValidator, gasHandler);
    }

    public static VariableCapacityGasTank output(LongSupplier capacity, Predicate<@NonNull Gas> validator, @Nullable IMekanismGasHandler gasHandler) {
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(validator, "Gas validity check cannot be null");
        return new VariableCapacityGasTank(capacity, (BiPredicate<Gas, AutomationType>)alwaysTrueBi, (BiPredicate<Gas, AutomationType>)internalOnly, validator, null, gasHandler);
    }

    protected VariableCapacityGasTank(LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IMekanismGasHandler gasHandler) {
        super(capacity.getAsLong(), canExtract, canInsert, validator, attributeValidator, gasHandler);
        this.capacity = capacity;
    }

    @Override
    public long getCapacity() {
        return this.capacity.getAsLong();
    }

    @Override
    public long setStackSize(long amount, @Nonnull Action action) {
        if (this.isEmpty()) {
            return 0L;
        }
        if (amount <= 0L) {
            if (action.execute()) {
                this.setStack(this.getEmptyStack());
            }
            return 0L;
        }
        long maxStackSize = this.getCapacity();
        if (maxStackSize > 0L && amount > maxStackSize) {
            amount = maxStackSize;
        }
        if (this.getStored() == amount || action.simulate()) {
            return amount;
        }
        ((GasStack)this.stored).setAmount(amount);
        this.onContentsChanged();
        return amount;
    }
}

