/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.capabilities.chemical;

import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.attribute.ChemicalAttributeValidator;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IMekanismGasHandler;
import mekanism.api.inventory.AutomationType;
import mekanism.common.capabilities.chemical.VariableCapacityGasTank;
import mekanism.common.multiblock.SynchronizedData;
import mekanism.common.tile.TileEntityMultiblock;
import mekanism.common.tile.base.TileEntityUpdateable;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockGasTank<MULTIBLOCK extends TileEntityMultiblock<?>>
extends VariableCapacityGasTank {
    protected final MULTIBLOCK multiblock;

    public static <MULTIBLOCK extends TileEntityMultiblock<?>> MultiblockGasTank<MULTIBLOCK> create(MULTIBLOCK multiblock, LongSupplier capacity, Predicate<@NonNull Gas> validator) {
        return new MultiblockGasTank<MULTIBLOCK>(multiblock, capacity, validator);
    }

    public static <MULTIBLOCK extends TileEntityMultiblock<?>> MultiblockGasTank<MULTIBLOCK> create(MULTIBLOCK multiblock, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> validator) {
        return new MultiblockGasTank<MULTIBLOCK>(multiblock, capacity, canExtract, canInsert, validator, null, null);
    }

    public static <MULTIBLOCK extends TileEntityMultiblock<?>> MultiblockGasTank<MULTIBLOCK> create(MULTIBLOCK tile, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IMekanismGasHandler gasHandler) {
        Objects.requireNonNull(tile, "Tile cannot be null");
        Objects.requireNonNull(capacity, "Capacity supplier cannot be null");
        Objects.requireNonNull(validator, "Gas validity check cannot be null");
        Objects.requireNonNull(canExtract, "Extraction validity check cannot be null");
        Objects.requireNonNull(canInsert, "Insertion validity check cannot be null");
        return new MultiblockGasTank<MULTIBLOCK>(tile, capacity, canExtract, canInsert, validator, attributeValidator, gasHandler);
    }

    protected MultiblockGasTank(MULTIBLOCK multiblock, LongSupplier capacity, Predicate<@NonNull Gas> validator) {
        super(capacity, (Gas stack, AutomationType automationType) -> automationType != AutomationType.EXTERNAL || multiblock.structure != null, (Gas stack, AutomationType automationType) -> automationType != AutomationType.EXTERNAL || multiblock.structure != null, validator, null, null);
        this.multiblock = multiblock;
    }

    protected MultiblockGasTank(MULTIBLOCK multiblock, LongSupplier capacity, BiPredicate<@NonNull Gas, @NonNull AutomationType> canExtract, BiPredicate<@NonNull Gas, @NonNull AutomationType> canInsert, Predicate<@NonNull Gas> validator, @Nullable ChemicalAttributeValidator attributeValidator, @Nullable IMekanismGasHandler gasHandler) {
        super(capacity, canExtract, canInsert, validator, attributeValidator, gasHandler);
        this.multiblock = multiblock;
    }

    @Override
    public void onContentsChanged() {
        super.onContentsChanged();
        if (this.multiblock.func_145830_o() && !((TileEntityUpdateable)((Object)this.multiblock)).isRemote()) {
            ((TileEntityUpdateable)((Object)this.multiblock)).markDirty(false);
            if (((TileEntityMultiblock)this.multiblock).structure != null) {
                ((SynchronizedData)((TileEntityMultiblock)this.multiblock).structure).markDirtyComparator(this.multiblock.func_145831_w());
            }
        }
    }
}

