/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.base;

import javax.annotation.Nonnull;
import mekanism.api.IIncrementalEnum;
import mekanism.api.math.MathUtils;
import mekanism.api.text.IHasTextComponent;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import net.minecraft.util.text.ITextComponent;

public enum ContainerEditMode implements IIncrementalEnum<ContainerEditMode>,
IHasTextComponent
{
    BOTH(MekanismLang.FLUID_CONTAINER_BOTH),
    FILL(MekanismLang.FLUID_CONTAINER_FILL),
    EMPTY(MekanismLang.FLUID_CONTAINER_EMPTY);

    private static final ContainerEditMode[] MODES;
    private final ILangEntry langEntry;

    private ContainerEditMode(ILangEntry langEntry) {
        this.langEntry = langEntry;
    }

    @Override
    public ITextComponent getTextComponent() {
        return this.langEntry.translate(new Object[0]);
    }

    @Override
    @Nonnull
    public ContainerEditMode byIndex(int index) {
        return ContainerEditMode.byIndexStatic(index);
    }

    public static ContainerEditMode byIndexStatic(int index) {
        return MathUtils.getByIndexMod(MODES, index);
    }

    static {
        MODES = ContainerEditMode.values();
    }
}

