/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.UUID;
import mekanism.client.sound.PlayerSound;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketGearStateUpdate;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.IWorld;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class PlayerState {
    private Set<UUID> activeJetpacks = new ObjectOpenHashSet();
    private Set<UUID> activeGasmasks = new ObjectOpenHashSet();
    private Set<UUID> activeFlamethrowers = new ObjectOpenHashSet();
    private IWorld world;

    public void clear() {
        this.activeJetpacks.clear();
        this.activeGasmasks.clear();
        this.activeFlamethrowers.clear();
        if (FMLEnvironment.dist.isClient()) {
            SoundHandler.clearPlayerSounds();
        }
    }

    public void clearPlayer(UUID uuid) {
        this.activeJetpacks.remove(uuid);
        this.activeGasmasks.remove(uuid);
        this.activeFlamethrowers.remove(uuid);
        if (FMLEnvironment.dist.isClient()) {
            SoundHandler.clearPlayerSounds(uuid);
        }
    }

    public void init(IWorld world) {
        this.world = world;
    }

    public void setJetpackState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeJetpacks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeJetpacks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeJetpacks.add(uuid);
        }
        if (changed && this.world.func_201670_d()) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.JETPACK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.JETPACK);
            }
        }
    }

    public boolean isJetpackOn(PlayerEntity p) {
        return this.activeJetpacks.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveJetpacks() {
        return this.activeJetpacks;
    }

    public void setGasmaskState(UUID uuid, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeGasmasks.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeGasmasks.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeGasmasks.add(uuid);
        }
        if (changed && this.world.func_201670_d()) {
            if (isLocal) {
                Mekanism.packetHandler.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.GAS_MASK, uuid, isActive));
            }
            if (isActive && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.GAS_MASK);
            }
        }
    }

    public boolean isGasmaskOn(PlayerEntity p) {
        return this.activeGasmasks.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveGasmasks() {
        return this.activeGasmasks;
    }

    public void setFlamethrowerState(UUID uuid, boolean isActive, boolean isLocal) {
        this.setFlamethrowerState(uuid, isActive, isActive, isLocal);
    }

    public void setFlamethrowerState(UUID uuid, boolean hasFlameThrower, boolean isActive, boolean isLocal) {
        boolean changed;
        boolean alreadyActive = this.activeFlamethrowers.contains(uuid);
        boolean bl = changed = alreadyActive != isActive;
        if (alreadyActive && !isActive) {
            this.activeFlamethrowers.remove(uuid);
        } else if (!alreadyActive && isActive) {
            this.activeFlamethrowers.add(uuid);
        }
        if (this.world.func_201670_d()) {
            boolean startSound;
            if (changed) {
                if (isLocal) {
                    Mekanism.packetHandler.sendToServer(new PacketGearStateUpdate(PacketGearStateUpdate.GearType.FLAMETHROWER, uuid, isActive));
                }
                startSound = isActive;
            } else {
                boolean bl2 = startSound = !isActive && hasFlameThrower;
            }
            if (startSound && MekanismConfig.client.enablePlayerSounds.get()) {
                SoundHandler.startSound(this.world, uuid, PlayerSound.SoundType.FLAMETHROWER);
            }
        }
    }

    public boolean isFlamethrowerOn(PlayerEntity p) {
        return this.activeFlamethrowers.contains(p.func_110124_au());
    }

    public Set<UUID> getActiveFlamethrowers() {
        return this.activeFlamethrowers;
    }
}

