/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.transmitter;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.client.render.MekanismRenderType;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.render.transmitter.RenderTransmitterBase;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.transmitters.TransmitterImpl;
import mekanism.common.transmitters.grid.GasNetwork;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.profiler.IProfiler;

@ParametersAreNonnullByDefault
public class RenderPressurizedTube
extends RenderTransmitterBase<TileEntityPressurizedTube> {
    public RenderPressurizedTube(TileEntityRendererDispatcher renderer) {
        super(renderer);
    }

    @Override
    protected void render(TileEntityPressurizedTube tube, float partialTick, MatrixStack matrix, IRenderTypeBuffer renderer, int light, int overlayLight, IProfiler profiler) {
        TransmitterImpl transmitter = tube.getTransmitter();
        if (transmitter.hasTransmitterNetwork()) {
            GasNetwork network = (GasNetwork)transmitter.getTransmitterNetwork();
            if (!network.lastGas.isEmptyType() && !network.gasTank.isEmpty() && network.gasScale > 0.0f) {
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.5, 0.5, 0.5);
                this.renderModel(tube, matrix, renderer.getBuffer(MekanismRenderType.transmitterContents(AtlasTexture.field_110575_b)), network.lastGas.getTint(), network.gasScale, 0xF000F0, overlayLight, MekanismRenderer.getChemicalTexture(network.lastGas));
                matrix.func_227865_b_();
            }
        }
    }

    @Override
    protected String getProfilerSection() {
        return "pressurizedTube";
    }
}

