/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model.data;

import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.client.model.data.ModelProperties;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import net.minecraft.util.Direction;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class TransmitterModelData
implements IModelData {
    private final Map<Direction, TileEntitySidedPipe.ConnectionType> connections = new EnumMap<Direction, TileEntitySidedPipe.ConnectionType>(Direction.class);

    public void setConnectionData(Direction direction, TileEntitySidedPipe.ConnectionType connectionType) {
        this.connections.put(direction, connectionType);
    }

    public boolean hasProperty(ModelProperty<?> prop) {
        Direction direction = this.getDirection(prop);
        return direction != null && this.connections.containsKey(direction);
    }

    @Nullable
    public <T> T getData(ModelProperty<T> prop) {
        Direction direction = this.getDirection(prop);
        return (T)(direction == null ? null : this.connections.get(direction));
    }

    @Nullable
    public <T> T setData(ModelProperty<T> prop, T data) {
        Direction direction = this.getDirection(prop);
        if (direction != null) {
            if (data == null) {
                this.connections.remove(direction);
            } else {
                this.connections.put(direction, (TileEntitySidedPipe.ConnectionType)data);
            }
        }
        return data;
    }

    @Nullable
    private <T> Direction getDirection(ModelProperty<T> prop) {
        Direction direction = null;
        if (prop == ModelProperties.DOWN_CONNECTION) {
            direction = Direction.DOWN;
        } else if (prop == ModelProperties.UP_CONNECTION) {
            direction = Direction.UP;
        } else if (prop == ModelProperties.NORTH_CONNECTION) {
            direction = Direction.NORTH;
        } else if (prop == ModelProperties.SOUTH_CONNECTION) {
            direction = Direction.SOUTH;
        } else if (prop == ModelProperties.WEST_CONNECTION) {
            direction = Direction.WEST;
        } else if (prop == ModelProperties.EAST_CONNECTION) {
            direction = Direction.EAST;
        }
        return direction;
    }

    public static class Colorable
    extends TransmitterModelData {
        private Boolean hasColor;

        public void setColor(boolean hasColor) {
            this.hasColor = hasColor;
        }

        @Override
        public boolean hasProperty(ModelProperty<?> prop) {
            if (prop == ModelProperties.COLOR) {
                return this.hasColor != null;
            }
            return super.hasProperty(prop);
        }

        @Override
        @Nullable
        public <T> T getData(ModelProperty<T> prop) {
            if (prop == ModelProperties.COLOR) {
                return (T)this.hasColor;
            }
            return super.getData(prop);
        }

        @Override
        @Nullable
        public <T> T setData(ModelProperty<T> prop, T data) {
            if (prop == ModelProperties.COLOR) {
                this.hasColor = (Boolean)data;
                return data;
            }
            return super.setData(prop, data);
        }
    }

    public static class Diversion
    extends TransmitterModelData {
    }
}

