/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Arrays;
import java.util.Collections;
import mekanism.api.providers.IBlockProvider;
import mekanism.api.recipes.SawmillRecipe;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiUpArrow;
import mekanism.client.gui.element.bar.GuiVerticalPowerBar;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;

public class SawmillRecipeCategory
extends BaseRecipeCategory<SawmillRecipe> {
    public SawmillRecipeCategory(IGuiHelper helper, IBlockProvider mekanismBlock) {
        super(helper, mekanismBlock, 28, 16, 144, 54);
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiUpArrow(this, 60, 38));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 55, 16));
        this.guiElements.add(new GuiSlot(SlotType.POWER, this, 55, 52).with(SlotOverlay.POWER));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT_WIDE, this, 111, 30));
        this.guiElements.add(new GuiVerticalPowerBar((IGuiWrapper)this, () -> 1.0, 164, 15));
        this.guiElements.add(new GuiProgress(() -> (double)this.timer.getValue() / 20.0, ProgressType.BAR, this, 78, 38));
    }

    public Class<? extends SawmillRecipe> getRecipeClass() {
        return SawmillRecipe.class;
    }

    public void setIngredients(SawmillRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, Collections.singletonList(recipe.getInput().getRepresentations()));
        ingredients.setOutputLists(VanillaTypes.ITEM, Arrays.asList(recipe.getMainOutputDefinition(), recipe.getSecondaryOutputDefinition()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, SawmillRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 27, 0);
        itemStacks.init(1, false, 87, 18);
        itemStacks.init(2, false, 103, 18);
        itemStacks.set(0, recipe.getInput().getRepresentations());
        itemStacks.set(1, recipe.getMainOutputDefinition());
        itemStacks.set(2, recipe.getSecondaryOutputDefinition());
    }

    @Override
    public void draw(SawmillRecipe recipe, double mouseX, double mouseY) {
        super.draw(recipe, mouseX, mouseY);
        double secondaryChance = recipe.getSecondaryChance();
        if (secondaryChance > 0.0) {
            this.getFont().func_211126_b(Math.round(secondaryChance * 100.0) + "%", 104.0f, 41.0f, 0x404040);
        }
    }
}

