/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import java.util.List;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class RotaryCondensentratorRecipeCategory
extends BaseRecipeCategory<RotaryRecipe> {
    private final boolean condensentrating;
    private final ResourceLocation uid;
    private final String title;

    public RotaryCondensentratorRecipeCategory(IGuiHelper helper, boolean condensentrating) {
        super(helper, MekanismBlocks.ROTARY_CONDENSENTRATOR, 3, 12, 170, 71);
        this.condensentrating = condensentrating;
        this.uid = new ResourceLocation("mekanism", condensentrating ? "rotary_condensentrator_condensentrating" : "rotary_condensentrator_decondensentrating");
        this.title = (condensentrating ? MekanismLang.CONDENSENTRATING : MekanismLang.DECONDENSENTRATING).translate(new Object[0]).func_150254_d();
        this.guiElements.add(new GuiProgress(() -> 1.0, condensentrating ? ProgressType.LARGE_RIGHT : ProgressType.LARGE_LEFT, this, 64, 39));
    }

    @Override
    public ResourceLocation getUid() {
        return this.uid;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiDownArrow(this, 159, 44));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 25, 13));
        this.guiElements.add(GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 133, 13));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 4, 24).with(SlotOverlay.PLUS));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT, this, 4, 55).with(SlotOverlay.MINUS));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 154, 24));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT, this, 154, 55));
    }

    public Class<? extends RotaryRecipe> getRecipeClass() {
        return RotaryRecipe.class;
    }

    public void setIngredients(RotaryRecipe recipe, IIngredients ingredients) {
        if (this.condensentrating) {
            if (recipe.hasGasToFluid()) {
                ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(recipe.getGasInput().getRepresentations()));
                ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getFluidOutputRepresentation());
            }
        } else if (recipe.hasFluidToGas()) {
            ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getFluidInput().getRepresentations()));
            ingredients.setOutput(MekanismJEI.TYPE_GAS, (Object)recipe.getGasOutputRepresentation());
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, RotaryRecipe recipe, IIngredients ingredients) {
        if (this.condensentrating) {
            if (recipe.hasGasToFluid()) {
                IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
                this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, true, 26 - this.xOffset, 14 - this.yOffset, 16, 58, recipe.getGasInput().getRepresentations(), true);
                IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
                fluidStacks.init(0, true, 134 - this.xOffset, 14 - this.yOffset, 16, 58, recipe.getFluidOutputRepresentation().getAmount(), false, this.fluidOverlayLarge);
                fluidStacks.set(0, recipe.getFluidOutputRepresentation());
            }
        } else if (recipe.hasFluidToGas()) {
            IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
            List fluidInputs = recipe.getFluidInput().getRepresentations();
            int max = fluidInputs.stream().mapToInt(FluidStack::getAmount).filter(input -> input >= 0).max().orElse(0);
            fluidStacks.init(0, false, 134 - this.xOffset, 14 - this.yOffset, 16, 58, max, false, this.fluidOverlayLarge);
            fluidStacks.set(0, fluidInputs);
            IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
            this.initGas((IGuiIngredientGroup<GasStack>)gasStacks, 0, false, 26 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(recipe.getGasOutputRepresentation()), true);
            gasStacks.set(0, (Object)recipe.getGasOutputRepresentation());
        }
    }
}

