/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import java.util.List;
import mekanism.api.recipes.FluidToFluidRecipe;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraftforge.fluids.FluidStack;

public class FluidToFluidRecipeCategory
extends BaseRecipeCategory<FluidToFluidRecipe> {
    public FluidToFluidRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER, 3, 12, 170, 62);
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiInnerScreen(this, 48, 19, 80, 40));
        this.guiElements.add(new GuiDownArrow(this, 32, 39));
        this.guiElements.add(new GuiDownArrow(this, 136, 39));
        this.guiElements.add(new GuiHorizontalRateBar(this, () -> 1.0, 48, 63));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 28, 20));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT, this, 28, 51));
        this.guiElements.add(new GuiSlot(SlotType.INPUT, this, 132, 20));
        this.guiElements.add(new GuiSlot(SlotType.OUTPUT, this, 132, 51));
        this.guiElements.add(GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 6, 13));
        this.guiElements.add(GuiFluidGauge.getDummy(GaugeType.STANDARD, this, 152, 13));
    }

    public Class<? extends FluidToFluidRecipe> getRecipeClass() {
        return FluidToFluidRecipe.class;
    }

    public void setIngredients(FluidToFluidRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.FLUID, Collections.singletonList(recipe.getInput().getRepresentations()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)recipe.getOutputRepresentation());
    }

    public void setRecipe(IRecipeLayout recipeLayout, FluidToFluidRecipe recipe, IIngredients ingredients) {
        IGuiFluidStackGroup fluidStacks = recipeLayout.getFluidStacks();
        List fluidInputs = recipe.getInput().getRepresentations();
        int max = fluidInputs.stream().mapToInt(FluidStack::getAmount).filter(input -> input >= 0).max().orElse(0);
        fluidStacks.init(0, true, 7 - this.xOffset, 14 - this.yOffset, 16, 58, max, false, this.fluidOverlayLarge);
        fluidStacks.init(1, false, 153 - this.xOffset, 14 - this.yOffset, 16, 58, recipe.getOutputRepresentation().getAmount(), false, this.fluidOverlayLarge);
        fluidStacks.set(0, fluidInputs);
        fluidStacks.set(1, recipe.getOutputRepresentation());
    }
}

