/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.chemical;

import com.google.common.base.MoreObjects;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.common.util.text.TextComponentUtil;
import mezz.jei.api.ingredients.IIngredientHelper;

public abstract class ChemicalStackHelper<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
implements IIngredientHelper<STACK> {
    protected abstract STACK getEmptyStack();

    protected abstract String getType();

    @Nullable
    public STACK getMatch(Iterable<STACK> ingredients, @Nonnull STACK toMatch) {
        for (ChemicalStack stack : ingredients) {
            if (!((ChemicalStack)toMatch).isTypeEqual((ChemicalStack)stack)) continue;
            return (STACK)stack;
        }
        return null;
    }

    public String getDisplayName(STACK ingredient) {
        return TextComponentUtil.build(ingredient).func_150254_d();
    }

    public String getUniqueId(STACK ingredient) {
        return this.getType().toLowerCase(Locale.ROOT) + ":" + ((ChemicalStack)ingredient).getTypeRegistryName();
    }

    public String getWildcardId(STACK ingredient) {
        return this.getUniqueId(ingredient);
    }

    public String getModId(STACK ingredient) {
        return ((ChemicalStack)ingredient).getTypeRegistryName().func_110624_b();
    }

    public String getResourceId(STACK ingredient) {
        return ((ChemicalStack)ingredient).getTypeRegistryName().func_110623_a();
    }

    public STACK copyIngredient(STACK ingredient) {
        return (STACK)((ChemicalStack)ingredient).copy();
    }

    public String getErrorInfo(@Nullable STACK ingredient) {
        if (ingredient == null) {
            ingredient = this.getEmptyStack();
        }
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(GasStack.class);
        Object chemical = ((ChemicalStack)ingredient).getType();
        toStringHelper.add(this.getType(), (Object)(((Chemical)chemical).isEmptyType() ? "none" : TextComponentUtil.build(chemical).func_150254_d()));
        if (!((ChemicalStack)ingredient).isEmpty()) {
            toStringHelper.add("Amount", ((ChemicalStack)ingredient).getAmount());
        }
        return toStringHelper.toString();
    }
}

