/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.robit;

import javax.annotation.Nonnull;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRobitScreen;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.bar.GuiHorizontalPowerBar;
import mekanism.client.gui.element.button.MekanismButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.entity.EntityRobit;
import mekanism.common.inventory.container.entity.robit.MainRobitContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketRobit;
import mekanism.common.util.text.EnergyDisplay;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiRobitMain
extends GuiMekanism<MainRobitContainer> {
    private final EntityRobit robit;
    private TextFieldWidget nameChangeField;
    private MekanismButton confirmName;

    public GuiRobitMain(MainRobitContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.robit = (EntityRobit)container.getEntity();
        this.dynamicSlots = true;
    }

    private void toggleNameChange() {
        this.confirmName.visible = this.nameChangeField.visible = !this.nameChangeField.visible;
        this.nameChangeField.func_146195_b(this.nameChangeField.visible);
    }

    private void changeName() {
        if (!this.nameChangeField.func_146179_b().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketRobit(this.robit.func_145782_y(), (ITextComponent)TextComponentUtil.getString(this.nameChangeField.func_146179_b())));
            this.toggleNameChange();
            this.nameChangeField.func_146180_a("");
        }
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiSideHolder(this, 176, 6, 106));
        this.addButton(new GuiRobitScreen((IGuiWrapper)this, 27, 16, 122, 56, () -> this.nameChangeField.visible));
        this.addButton(new GuiHorizontalPowerBar((IGuiWrapper)this, this.robit.getEnergyContainer(), 27, 74, 120));
        this.confirmName = new TranslationButton(this, this.getGuiLeft() + 58, this.getGuiTop() + 47, 60, 20, MekanismLang.BUTTON_CONFIRM, this::changeName);
        this.addButton(this.confirmName);
        this.confirmName.visible = false;
        this.nameChangeField = new TextFieldWidget(this.font, this.getGuiLeft() + 48, this.getGuiTop() + 21, 80, 12, "");
        this.addButton((Widget)this.nameChangeField);
        this.nameChangeField.func_146203_f(12);
        this.nameChangeField.func_146195_b(true);
        this.nameChangeField.visible = false;
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 6, this.getGuiTop() + 16, 18, this.getButtonLocation("home"), () -> {
            Mekanism.packetHandler.sendToServer(new PacketRobit(PacketRobit.RobitPacketType.GO_HOME, this.robit.func_145782_y()));
            this.minecraft.func_147108_a(null);
        }, this.getOnHover(MekanismLang.ROBIT_TELEPORT)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 6, this.getGuiTop() + 35, 18, this.getButtonLocation("drop"), () -> Mekanism.packetHandler.sendToServer(new PacketRobit(PacketRobit.RobitPacketType.DROP_PICKUP, this.robit.func_145782_y())), this.getOnHover(MekanismLang.ROBIT_TOGGLE_PICKUP)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 6, this.getGuiTop() + 54, 18, this.getButtonLocation("rename"), this::toggleNameChange, this.getOnHover(MekanismLang.ROBIT_RENAME)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 152, this.getGuiTop() + 54, 18, this.getButtonLocation("follow"), () -> Mekanism.packetHandler.sendToServer(new PacketRobit(PacketRobit.RobitPacketType.FOLLOW, this.robit.func_145782_y())), this.getOnHover(MekanismLang.ROBIT_TOGGLE_FOLLOW)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 179, this.getGuiTop() + 10, 18, this.getButtonLocation("main"), () -> {}, this.getOnHover(MekanismLang.ROBIT)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 179, this.getGuiTop() + 30, 18, this.getButtonLocation("crafting"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_CRAFTING, this.robit.func_145782_y())), this.getOnHover(MekanismLang.ROBIT_CRAFTING)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 179, this.getGuiTop() + 50, 18, this.getButtonLocation("inventory"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_INVENTORY, this.robit.func_145782_y())), this.getOnHover(MekanismLang.ROBIT_INVENTORY)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 179, this.getGuiTop() + 70, 18, this.getButtonLocation("smelting"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_SMELTING, this.robit.func_145782_y())), this.getOnHover(MekanismLang.ROBIT_SMELTING)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 179, this.getGuiTop() + 90, 18, this.getButtonLocation("repair"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedEntityButton.ROBIT_REPAIR, this.robit.func_145782_y())), this.getOnHover(MekanismLang.ROBIT_REPAIR)));
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String s = this.nameChangeField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.nameChangeField.func_146180_a(s);
    }

    public boolean charTyped(char c, int keyCode) {
        if (this.nameChangeField.func_212955_f()) {
            return this.nameChangeField.charTyped(c, keyCode);
        }
        return super.charTyped(c, keyCode);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.nameChangeField.func_212955_f()) {
            if (keyCode == 256) {
                this.nameChangeField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                this.changeName();
                return true;
            }
            return this.nameChangeField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString((ITextComponent)MekanismLang.ROBIT.translate(new Object[0]), 76, 6, 0x404040);
        if (!this.nameChangeField.visible) {
            String owner = this.robit.getOwnerName().length() > 14 ? this.robit.getOwnerName().subSequence(0, 14) : this.robit.getOwnerName();
            this.renderScaledText((ITextComponent)MekanismLang.ROBIT_GREETING.translate(this.robit.func_200200_C_()), 29, 18, 52480, 119);
            this.renderScaledText((ITextComponent)MekanismLang.ENERGY.translate(EnergyDisplay.of(this.robit.getEnergyContainer().getEnergy(), this.robit.getEnergyContainer().getMaxEnergy())), 29, 32, 52480, 119);
            this.renderScaledText((ITextComponent)MekanismLang.ROBIT_FOLLOWING.translate(this.robit.getFollowing()), 29, 41, 52480, 119);
            this.renderScaledText((ITextComponent)MekanismLang.ROBIT_DROP_PICKUP.translate(this.robit.getDropPickup()), 29, 50, 52480, 119);
            this.renderScaledText((ITextComponent)MekanismLang.ROBIT_OWNER.translate(owner), 29, 59, 52480, 119);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public void tick() {
        super.tick();
        if (this.nameChangeField.visible) {
            this.nameChangeField.func_146178_a();
        }
    }
}

