/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.filter.GuiTagFilter;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.TagCache;
import mekanism.common.content.transporter.TTagFilter;
import mekanism.common.inventory.container.tile.filter.LSTagFilterContainer;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiTTagFilter
extends GuiTagFilter<TTagFilter, TileEntityLogisticalSorter, LSTagFilterContainer> {
    public GuiTTagFilter(LSTagFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.origFilter = container.getOrigFilter();
        this.filter = container.getFilter();
        this.isNew = container.isNew();
    }

    @Override
    protected void addButtons() {
        this.addButton(new GuiInnerScreen(this, 33, 18, 111, 43));
        this.addButton(new GuiInnerScreen(this, 130, 46, 14, 14));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 18));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 43));
        this.saveButton = new TranslationButton(this, this.getGuiLeft() + 47, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_SAVE, () -> {
            if (!this.text.func_146179_b().isEmpty()) {
                this.setText();
            }
            if (((TTagFilter)this.filter).getTagName() != null && !((TTagFilter)this.filter).getTagName().isEmpty()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
            } else {
                this.status = MekanismLang.TAG_FILTER_NO_TAG.translateColored(EnumColor.DARK_RED, new Object[0]);
                this.ticker = 20;
            }
        });
        this.addButton(this.saveButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 109, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), true, this.origFilter, null));
            this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
        });
        this.addButton(this.deleteButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> this.sendPacketToServer(this.isNew ? PacketGuiButtonPress.ClickedTileButton.LS_SELECT_FILTER_TYPE : PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 11, this.getGuiTop() + 64, 11, this.getButtonLocation("default"), () -> {
            ((TTagFilter)this.filter).allowDefault = !((TTagFilter)this.filter).allowDefault;
        }, this.getOnHover(MekanismLang.FILTER_ALLOW_DEFAULT)));
        this.checkboxButton = new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 131, this.getGuiTop() + 47, 12, this.getButtonLocation("checkmark"), this::setText);
        this.addButton(this.checkboxButton);
        this.addButton(new ColorButton((IGuiWrapper)this, this.getGuiLeft() + 12, this.getGuiTop() + 44, 16, 16, () -> ((TTagFilter)this.filter).color, () -> {
            ((TTagFilter)this.filter).color = GuiTTagFilter.hasShiftDown() ? null : TransporterUtils.increment(((TTagFilter)this.filter).color);
        }, () -> {
            ((TTagFilter)this.filter).color = TransporterUtils.decrement(((TTagFilter)this.filter).color);
        }));
    }

    @Override
    protected void updateStackList(String oreName) {
        this.iterStacks = TagCache.getItemTagStacks(oreName);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }
}

