/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.text.EnumColor;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.ColorButton;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.filter.GuiMaterialFilter;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.content.transporter.TMaterialFilter;
import mekanism.common.inventory.container.tile.filter.LSMaterialFilterContainer;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.TransporterUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiTMaterialFilter
extends GuiMaterialFilter<TMaterialFilter, TileEntityLogisticalSorter, LSMaterialFilterContainer> {
    public GuiTMaterialFilter(LSMaterialFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.origFilter = container.getOrigFilter();
        this.filter = container.getFilter();
        this.isNew = container.isNew();
    }

    @Override
    protected void addButtons() {
        this.addButton(new GuiInnerScreen(this, 33, 18, 93, 43));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 18).setRenderHover(true));
        this.addButton(new GuiSlot(SlotType.NORMAL, this, 11, 43));
        this.saveButton = new TranslationButton(this, this.getGuiLeft() + 47, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_SAVE, () -> {
            if (!((TMaterialFilter)this.filter).getMaterialItem().func_190926_b()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
            } else {
                this.status = MekanismLang.ITEM_FILTER_NO_ITEM.translateColored(EnumColor.DARK_RED, new Object[0]);
                this.ticker = 20;
            }
        });
        this.addButton(this.saveButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 109, this.getGuiTop() + 62, 60, 20, MekanismLang.BUTTON_DELETE, () -> {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityLogisticalSorter)this.tile).func_174877_v(), true, this.origFilter, null));
            this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
        });
        this.addButton(this.deleteButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> this.sendPacketToServer(this.isNew ? PacketGuiButtonPress.ClickedTileButton.LS_SELECT_FILTER_TYPE : PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 11, this.getGuiTop() + 64, 11, this.getButtonLocation("default"), () -> {
            ((TMaterialFilter)this.filter).allowDefault = !((TMaterialFilter)this.filter).allowDefault;
        }, this.getOnHover(MekanismLang.FILTER_ALLOW_DEFAULT)));
        this.addButton(new ColorButton((IGuiWrapper)this, this.getGuiLeft() + 12, this.getGuiTop() + 44, 16, 16, () -> ((TMaterialFilter)this.filter).color, () -> {
            ((TMaterialFilter)this.filter).color = GuiTMaterialFilter.hasShiftDown() ? null : TransporterUtils.increment(((TMaterialFilter)this.filter).color);
        }, () -> {
            ((TMaterialFilter)this.filter).color = TransporterUtils.decrement(((TMaterialFilter)this.filter).color);
        }));
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (!((TMaterialFilter)this.filter).getMaterialItem().func_190926_b()) {
            this.renderScaledText(((TMaterialFilter)this.filter).getMaterialItem().func_200301_q(), 35, 41, 52480, 107);
        }
        this.drawTransporterForegroundLayer(((TMaterialFilter)this.filter).getMaterialItem());
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        if (button == 0 && this.overTypeInput(mouseX - (double)this.getGuiLeft(), mouseY - (double)this.getGuiTop())) {
            this.materialMouseClicked();
        }
        return true;
    }
}

