/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.util.Collections;
import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.filter.GuiTextFilterBase;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.filter.OredictionificatorFilterContainer;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityOredictionificator;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiOredictionificatorFilter
extends GuiTextFilterBase<TileEntityOredictionificator.OredictionificatorFilter, TileEntityOredictionificator, OredictionificatorFilterContainer> {
    private GuiSlot slot;

    public GuiOredictionificatorFilter(OredictionificatorFilterContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.origFilter = container.getOrigFilter();
        this.filter = container.getFilter();
        this.isNew = container.isNew();
        this.updateRenderStack();
    }

    @Override
    protected boolean wasTextboxKey(char c, int i) {
        return super.wasTextboxKey(c, i) || c == '_' || c == ':' || c == '/';
    }

    @Override
    protected void addButtons() {
        this.addButton(new GuiInnerScreen(this, 129, 47, 14, 14));
        this.slot = new GuiSlot(SlotType.NORMAL, this, 44, 18);
        this.addButton(this.slot);
        this.saveButton = new TranslationButton(this, this.getGuiLeft() + 31, this.getGuiTop() + 62, 54, 20, MekanismLang.BUTTON_SAVE, () -> {
            if (!this.text.func_146179_b().isEmpty()) {
                this.setText();
            }
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter(((TileEntityOredictionificator)this.tile).func_174877_v(), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityOredictionificator)this.tile).func_174877_v(), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
            }
        });
        this.addButton(this.saveButton);
        this.deleteButton = new TranslationButton(this, this.getGuiLeft() + 89, this.getGuiTop() + 62, 54, 20, MekanismLang.BUTTON_DELETE, () -> {
            Mekanism.packetHandler.sendToServer(new PacketEditFilter(((TileEntityOredictionificator)this.tile).func_174877_v(), true, this.origFilter, null));
            this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON);
        });
        this.addButton(this.deleteButton);
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> this.sendPacketToServer(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 31, this.getGuiTop() + 21, 12, this.getButtonLocation("left"), () -> {
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter()) {
                ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).previous();
                this.updateRenderStack();
            }
        }, this.getOnHover(MekanismLang.LAST_ITEM)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 63, this.getGuiTop() + 21, 12, this.getButtonLocation("right"), () -> {
            if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter()) {
                ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).next();
                this.updateRenderStack();
            }
        }, this.getOnHover(MekanismLang.NEXT_ITEM)));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 130, this.getGuiTop() + 48, 12, this.getButtonLocation("checkmark"), this::setText));
    }

    @Override
    public void setText() {
        String newFilter = this.text.func_146179_b().toLowerCase();
        String modid = "forge";
        if (newFilter.contains(":")) {
            String[] split = newFilter.split(":");
            modid = split[0];
            newFilter = split[1];
        }
        List possibleFilters = TileEntityOredictionificator.possibleFilters.getOrDefault(modid, Collections.emptyList());
        if (possibleFilters.stream().anyMatch(newFilter::startsWith)) {
            ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).setFilter(new ResourceLocation(modid, newFilter));
            this.text.func_146180_a("");
            this.updateRenderStack();
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.saveButton.active = ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter();
        this.deleteButton.active = !this.isNew;
    }

    @Override
    protected TextFieldWidget createTextField() {
        return new TextFieldWidget(this.font, this.getGuiLeft() + 33, this.getGuiTop() + 48, 96, 12, "");
    }

    @Override
    public void init() {
        super.init();
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText((ITextComponent)(this.isNew ? MekanismLang.FILTER_NEW : MekanismLang.FILTER_EDIT).translate(MekanismLang.FILTER), 0, this.getXSize(), 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.FILTER_INDEX.translate(((TileEntityOredictionificator.OredictionificatorFilter)this.filter).getIndex()), 79, 23, 0x404040);
        if (((TileEntityOredictionificator.OredictionificatorFilter)this.filter).hasFilter()) {
            this.renderScaledText(((TileEntityOredictionificator.OredictionificatorFilter)this.filter).getFilterText(), 32, 38, 0x404040, 111);
        }
        this.renderItem(this.renderStack, 45, 19);
        int xAxis = mouseX - this.getGuiLeft();
        int yAxis = mouseY - this.getGuiTop();
        if (this.text.isMouseOver((double)mouseX, (double)mouseY)) {
            this.displayTooltip((ITextComponent)MekanismLang.TAG_COMPAT.translate(new Object[0]), xAxis, yAxis);
        } else if (xAxis >= 45 && xAxis <= 61 && yAxis >= 19 && yAxis <= 35 && !this.renderStack.func_190926_b()) {
            this.displayTooltip((ITextComponent)MekanismLang.GENERIC_WITH_PARENTHESIS.translate(this.renderStack, this.renderStack.func_77973_b().getRegistryName().func_110624_b()), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        super.mouseClicked(mouseX, mouseY, button);
        this.text.mouseClicked(mouseX, mouseY, button);
        return true;
    }

    private void updateRenderStack() {
        this.renderStack = ((TileEntityOredictionificator.OredictionificatorFilter)this.filter).getResult();
    }
}

