/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.base.ILangEntry;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GuiBoilerTab
extends GuiTabElementType<TileEntityBoilerCasing, BoilerTab> {
    public GuiBoilerTab(IGuiWrapper gui, TileEntityBoilerCasing tile, BoilerTab type) {
        super(gui, tile, type);
    }

    public static enum BoilerTab implements TabType<TileEntityBoilerCasing>
    {
        MAIN("gases.png", MekanismLang.MAIN_TAB, PacketGuiButtonPress.ClickedTileButton.TAB_MAIN),
        STAT("stats.png", MekanismLang.BOILER_STATS, PacketGuiButtonPress.ClickedTileButton.TAB_STATS);

        private final PacketGuiButtonPress.ClickedTileButton button;
        private final ILangEntry description;
        private final String path;

        private BoilerTab(String path, ILangEntry desc, PacketGuiButtonPress.ClickedTileButton button) {
            this.path = path;
            this.description = desc;
            this.button = button;
        }

        @Override
        public ResourceLocation getResource() {
            return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.path);
        }

        @Override
        public void onClick(TileEntityBoilerCasing tile) {
            Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(this.button, tile));
        }

        @Override
        public ITextComponent getDescription() {
            return this.description.translate(new Object[0]);
        }

        @Override
        public int getYPos() {
            return 6;
        }
    }
}

