/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.math.MathUtils;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiTankGauge;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.util.text.TextComponentUtil;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;

public class GuiGasGauge
extends GuiTankGauge<Gas, IGasTank> {
    public GuiGasGauge(IGasInfoHandler handler, GaugeType type, IGuiWrapper gui, int x, int y) {
        super(type, gui, x, y, handler, PacketDropperUse.TankType.GAS_TANK);
    }

    public GuiGasGauge(final Supplier<IGasTank> tankSupplier, final Supplier<List<IGasTank>> tanksSupplier, GaugeType type, IGuiWrapper gui, int x, int y) {
        this(new IGasInfoHandler(){

            @Override
            @Nullable
            public IGasTank getTank() {
                return (IGasTank)tankSupplier.get();
            }

            @Override
            public int getTankIndex() {
                IGasTank tank = this.getTank();
                return tank == null ? -1 : ((List)tanksSupplier.get()).indexOf(tank);
            }
        }, type, gui, x, y);
    }

    public static GuiGasGauge getDummy(GaugeType type, IGuiWrapper gui, int x, int y) {
        GuiGasGauge gauge = new GuiGasGauge(null, type, gui, x, y);
        gauge.dummy = true;
        return gauge;
    }

    @Override
    public TransmissionType getTransmission() {
        return TransmissionType.GAS;
    }

    @Override
    public int getScaledLevel() {
        if (this.dummy) {
            return this.height - 2;
        }
        IGasTank tank = (IGasTank)this.getTank();
        if (tank == null || tank.isEmpty() || tank.getCapacity() == 0L) {
            return 0;
        }
        double scale = (double)tank.getStored() / (double)tank.getCapacity();
        return MathUtils.clampToInt(Math.round(scale * (double)(this.height - 2)));
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.dummy) {
            return MekanismRenderer.getChemicalTexture((Chemical)this.dummyType);
        }
        return this.getTank() == null || ((IGasTank)this.getTank()).isEmpty() ? null : MekanismRenderer.getChemicalTexture(((IGasTank)this.getTank()).getType());
    }

    @Override
    public ITextComponent getTooltipText() {
        if (this.dummy) {
            return TextComponentUtil.build(this.dummyType);
        }
        IGasTank tank = (IGasTank)this.getTank();
        if (tank == null || tank.isEmpty()) {
            return MekanismLang.EMPTY.translate(new Object[0]);
        }
        long amount = tank.getStored();
        if (amount == Long.MAX_VALUE) {
            return MekanismLang.GENERIC_STORED.translate(tank.getType(), MekanismLang.INFINITE);
        }
        return MekanismLang.GENERIC_STORED_MB.translate(tank.getType(), amount);
    }

    @Override
    protected void applyRenderColor() {
        if (this.dummy || this.getTank() == null) {
            MekanismRenderer.color((Chemical)this.dummyType);
        } else {
            MekanismRenderer.color(((IGasTank)this.getTank()).getStack());
        }
    }

    @Override
    @Nullable
    public Object getIngredient() {
        return ((IGasTank)this.getTank()).isEmpty() ? null : ((IGasTank)this.getTank()).getStack();
    }

    public static interface IGasInfoHandler
    extends GuiTankGauge.ITankInfoHandler<IGasTank> {
    }
}

