/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiTexturedElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.text.ITextComponent;

public class GuiGraph
extends GuiTexturedElement {
    private static int textureWidth = 2;
    private static int textureHeight = 10;
    private final GuiInnerScreen innerScreen;
    private final IntList graphData = new IntArrayList();
    private final GraphDataHandler dataHandler;
    private int currentScale = 10;
    private boolean fixedScale = false;

    public GuiGraph(IGuiWrapper gui, int x, int y, int width, int height, GraphDataHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "graph.png"), gui, x, y, width, height);
        this.innerScreen = new GuiInnerScreen(gui, x - 1, y - 1, width + 2, height + 2);
        this.dataHandler = handler;
    }

    public void enableFixedScale(int scale) {
        this.fixedScale = true;
        this.currentScale = scale;
    }

    public void addData(int data) {
        if (this.graphData.size() == this.width) {
            this.graphData.removeInt(0);
        }
        this.graphData.add(data);
        if (!this.fixedScale) {
            IntListIterator intListIterator = this.graphData.iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                if (i <= this.currentScale) continue;
                this.currentScale = i;
            }
        }
    }

    @Override
    public void renderButton(int mouseX, int mouseY, float partialTicks) {
        this.innerScreen.renderButton(mouseX, mouseY, partialTicks);
        GuiGraph.minecraft.field_71446_o.func_110577_a(this.getResource());
        int size = this.graphData.size();
        for (int i = 0; i < size; ++i) {
            int data = Math.min(this.currentScale, this.graphData.getInt(i));
            int relativeHeight = (int)((double)(data * this.height) / (double)this.currentScale);
            GuiGraph.blit((int)(this.x + i), (int)(this.y + this.height - relativeHeight), (float)0.0f, (float)0.0f, (int)1, (int)1, (int)textureWidth, (int)textureHeight);
            int relativeModulo = (relativeHeight - 1) % 10;
            int displays = (relativeHeight - 1) / 10 + (relativeModulo > 0 ? 1 : 0);
            RenderSystem.shadeModel((int)7425);
            RenderSystem.disableAlphaTest();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.8f * (float)i / (float)size));
            for (int iter = 0; iter < displays; ++iter) {
                int heightComponent = relativeModulo > 0 && iter == displays - 1 ? relativeModulo : 10;
                GuiGraph.blit((int)(this.x + i), (int)(this.y + this.height - heightComponent - 10 * iter), (float)11.0f, (float)0.0f, (int)1, (int)heightComponent, (int)textureWidth, (int)textureHeight);
            }
            MekanismRenderer.resetColor();
            RenderSystem.disableBlend();
            RenderSystem.enableAlphaTest();
        }
    }

    public void renderToolTip(int mouseX, int mouseY) {
        int heightCalculated = this.height - (mouseY - this.guiObj.getTop() - this.y);
        int scaled = (int)((double)(heightCalculated * this.currentScale) / (double)this.height);
        this.displayTooltip(this.dataHandler.getDataDisplay(scaled), mouseX, mouseY);
    }

    public static interface GraphDataHandler {
        public ITextComponent getDataDisplay(int var1);
    }
}

