/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Arrays;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiVerticalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.tab.GuiMatrixTab;
import mekanism.common.MekanismLang;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.tile.TileEntityInductionCasing;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiMatrixStats
extends GuiMekanismTile<TileEntityInductionCasing, EmptyTileContainer<TileEntityInductionCasing>> {
    public GuiMatrixStats(EmptyTileContainer<TileEntityInductionCasing> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiMatrixTab((IGuiWrapper)this, (TileEntityInductionCasing)this.tile, GuiMatrixTab.MatrixTab.MAIN));
        this.addButton(new GuiEnergyGauge(new GuiEnergyGauge.IEnergyInfoHandler(){

            @Override
            public FloatingLong getEnergy() {
                return ((TileEntityInductionCasing)GuiMatrixStats.this.tile).getEnergy();
            }

            @Override
            public FloatingLong getMaxEnergy() {
                return ((TileEntityInductionCasing)GuiMatrixStats.this.tile).getMaxEnergy();
            }
        }, GaugeType.STANDARD, (IGuiWrapper)this, 6, 13));
        this.addButton(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.MATRIX_RECEIVING_RATE.translate(EnergyDisplay.of(((TileEntityInductionCasing)GuiMatrixStats.this.tile).getLastInput()));
            }

            @Override
            public double getLevel() {
                return ((TileEntityInductionCasing)GuiMatrixStats.this.tile).structure == null ? 0.0 : ((TileEntityInductionCasing)GuiMatrixStats.this.tile).getLastInput().divideToLevel(((SynchronizedMatrixData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).structure).getTransferCap());
            }
        }, 30, 13));
        this.addButton(new GuiVerticalRateBar(this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.MATRIX_OUTPUTTING_RATE.translate(EnergyDisplay.of(((TileEntityInductionCasing)GuiMatrixStats.this.tile).getLastOutput()));
            }

            @Override
            public double getLevel() {
                if (((TileEntityInductionCasing)GuiMatrixStats.this.tile).structure == null) {
                    return 0.0;
                }
                return ((TileEntityInductionCasing)GuiMatrixStats.this.tile).getLastOutput().divideToLevel(((SynchronizedMatrixData)((TileEntityInductionCasing)GuiMatrixStats.this.tile).structure).getTransferCap());
            }
        }, 38, 13));
        this.addButton(new GuiEnergyInfo(() -> Arrays.asList(MekanismLang.STORING.translate(EnergyDisplay.of(((TileEntityInductionCasing)this.tile).getEnergy(), ((TileEntityInductionCasing)this.tile).getMaxEnergy())), MekanismLang.MATRIX_INPUT_RATE.translate(EnergyDisplay.of(((TileEntityInductionCasing)this.tile).getLastInput())), MekanismLang.MATRIX_OUTPUT_RATE.translate(EnergyDisplay.of(((TileEntityInductionCasing)this.tile).getLastOutput()))), (IGuiWrapper)this));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawCenteredText((ITextComponent)MekanismLang.MATRIX_STATS.translate(new Object[0]), 0, this.getXSize(), 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.MATRIX_INPUT_AMOUNT.translate(new Object[0]), 53, 26, 0x797979);
        this.drawString(EnergyDisplay.of(((TileEntityInductionCasing)this.tile).getLastInput(), ((TileEntityInductionCasing)this.tile).getTransferCap()).getTextComponent(), 59, 35, 0x404040);
        this.drawString((ITextComponent)MekanismLang.MATRIX_OUTPUT_AMOUNT.translate(new Object[0]), 53, 46, 0x797979);
        this.drawString(EnergyDisplay.of(((TileEntityInductionCasing)this.tile).getLastOutput(), ((TileEntityInductionCasing)this.tile).getTransferCap()).getTextComponent(), 59, 55, 0x404040);
        this.drawString((ITextComponent)MekanismLang.MATRIX_DIMENSIONS.translate(new Object[0]), 8, 82, 0x797979);
        if (((TileEntityInductionCasing)this.tile).structure != null) {
            this.drawString((ITextComponent)MekanismLang.MATRIX_DIMENSION_REPRESENTATION.translate(((SynchronizedMatrixData)((TileEntityInductionCasing)this.tile).structure).volWidth, ((SynchronizedMatrixData)((TileEntityInductionCasing)this.tile).structure).volHeight, ((SynchronizedMatrixData)((TileEntityInductionCasing)this.tile).structure).volLength), 14, 91, 0x404040);
        }
        this.drawString((ITextComponent)MekanismLang.MATRIX_CONSTITUENTS.translate(new Object[0]), 8, 102, 0x797979);
        this.drawString((ITextComponent)MekanismLang.MATRIX_CELLS.translate(((TileEntityInductionCasing)this.tile).getCellCount()), 14, 111, 0x404040);
        this.drawString((ITextComponent)MekanismLang.MATRIX_PROVIDERS.translate(((TileEntityInductionCasing)this.tile).getProviderCount()), 14, 120, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }
}

