/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.tab.GuiAmplifierTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.network.PacketGuiSetEnergy;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;

public class GuiLaserAmplifier
extends GuiMekanismTile<TileEntityLaserAmplifier, MekanismTileContainer<TileEntityLaserAmplifier>> {
    private TextFieldWidget minField;
    private TextFieldWidget maxField;
    private TextFieldWidget timerField;

    public GuiLaserAmplifier(MekanismTileContainer<TileEntityLaserAmplifier> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiEnergyGauge(((TileEntityLaserAmplifier)this.tile).getEnergyContainer(), GaugeType.STANDARD, (IGuiWrapper)this, 6, 10));
        this.addButton(new GuiSecurityTab<TileEntityMekanism>((IGuiWrapper)this, this.tile));
        this.addButton(new GuiRedstoneControl(this, this.tile));
        this.addButton(new GuiAmplifierTab(this, (TileEntityLaserAmplifier)this.tile));
        this.timerField = new TextFieldWidget(this.font, this.getGuiLeft() + 96, this.getGuiTop() + 28, 36, 11, "");
        this.addButton((Widget)this.timerField);
        this.timerField.func_146203_f(4);
        this.minField = new TextFieldWidget(this.font, this.getGuiLeft() + 96, this.getGuiTop() + 43, 72, 11, "");
        this.addButton((Widget)this.minField);
        this.minField.func_146203_f(10);
        this.maxField = new TextFieldWidget(this.font, this.getGuiLeft() + 96, this.getGuiTop() + 58, 72, 11, "");
        this.addButton((Widget)this.maxField);
        this.maxField.func_146203_f(10);
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String prevTime = this.timerField.func_146179_b();
        String prevMin = this.minField.func_146179_b();
        String prevMax = this.maxField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.timerField.func_146180_a(prevTime);
        this.minField.func_146180_a(prevMin);
        this.maxField.func_146180_a(prevMax);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString(((TileEntityLaserAmplifier)this.tile).getName(), 55, 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.INVENTORY.translate(new Object[0]), 8, this.getYSize() - 96 + 2, 0x404040);
        if (((TileEntityLaserAmplifier)this.tile).time > 0) {
            this.drawString((ITextComponent)MekanismLang.DELAY.translate(((TileEntityLaserAmplifier)this.tile).time), 26, 30, 0x404040);
        } else {
            this.drawString((ITextComponent)MekanismLang.NO_DELAY.translate(new Object[0]), 26, 30, 0x404040);
        }
        this.drawString((ITextComponent)MekanismLang.MIN.translate(EnergyDisplay.of(((TileEntityLaserAmplifier)this.tile).minThreshold)), 26, 45, 0x404040);
        this.drawString((ITextComponent)MekanismLang.MAX.translate(EnergyDisplay.of(((TileEntityLaserAmplifier)this.tile).maxThreshold)), 26, 60, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    public void tick() {
        super.tick();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
        this.timerField.func_146178_a();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        TextFieldWidget focusedField = this.getFocusedField();
        if (focusedField != null) {
            if (keyCode == 256) {
                focusedField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                if (this.minField.func_212955_f()) {
                    this.setMinThreshold();
                } else if (this.maxField.func_212955_f()) {
                    this.setMaxThreshold();
                } else if (this.timerField.func_212955_f()) {
                    this.setTime();
                }
                return true;
            }
            return focusedField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        TextFieldWidget focusedField = this.getFocusedField();
        if (focusedField != null) {
            if (Character.isDigit(c) || (c == '.' || c == 'E') && focusedField != this.timerField) {
                return focusedField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    @Nullable
    private TextFieldWidget getFocusedField() {
        if (this.minField.func_212955_f()) {
            return this.minField;
        }
        if (this.maxField.func_212955_f()) {
            return this.maxField;
        }
        if (this.timerField.func_212955_f()) {
            return this.timerField;
        }
        return null;
    }

    private void setMinThreshold() {
        if (!this.minField.func_146179_b().isEmpty()) {
            try {
                Mekanism.packetHandler.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.MIN_THRESHOLD, ((TileEntityLaserAmplifier)this.tile).func_174877_v(), MekanismUtils.convertToJoules(FloatingLong.parseFloatingLong(this.minField.func_146179_b()))));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.minField.func_146180_a("");
        }
    }

    private void setMaxThreshold() {
        if (!this.maxField.func_146179_b().isEmpty()) {
            try {
                Mekanism.packetHandler.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.MAX_THRESHOLD, ((TileEntityLaserAmplifier)this.tile).func_174877_v(), MekanismUtils.convertToJoules(FloatingLong.parseFloatingLong(this.maxField.func_146179_b()))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.maxField.func_146180_a("");
        }
    }

    private void setTime() {
        if (!this.timerField.func_146179_b().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_TIME, this.tile, Integer.parseInt(this.timerField.func_146179_b())));
            this.timerField.func_146180_a("");
        }
    }
}

