/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.TagCache;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.ITagFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.inventory.container.tile.EmptyTileContainer;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.tile.TileEntityDigitalMiner;
import mekanism.common.util.text.BooleanStateDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiDigitalMinerConfig
extends GuiFilterHolder<MinerFilter<?>, TileEntityDigitalMiner, EmptyTileContainer<TileEntityDigitalMiner>> {
    private TextFieldWidget radiusField;
    private TextFieldWidget minField;
    private TextFieldWidget maxField;

    public GuiDigitalMinerConfig(EmptyTileContainer<TileEntityDigitalMiner> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
    }

    @Override
    public void tick() {
        super.tick();
        this.radiusField.func_146178_a();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
    }

    @Override
    public void init() {
        super.init();
        this.addButton(new GuiInnerScreen(this, 38, 66, 13, 13));
        this.addButton(new GuiInnerScreen(this, 38, 91, 13, 13));
        this.addButton(new GuiInnerScreen(this, 38, 116, 13, 13));
        this.addButton(new TranslationButton(this, this.getGuiLeft() + 56, this.getGuiTop() + 136, 96, 20, MekanismLang.BUTTON_NEW_FILTER, () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DM_SELECT_FILTER_TYPE, this.tile))));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 5, this.getGuiTop() + 5, 11, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, this.tile))));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 39, this.getGuiTop() + 67, 11, 12, this.getButtonLocation("checkmark"), this::setRadius));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 39, this.getGuiTop() + 92, 11, 12, this.getButtonLocation("checkmark"), this::setMinY));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 39, this.getGuiTop() + 117, 11, 12, this.getButtonLocation("checkmark"), this::setMaxY));
        this.addButton(new MekanismImageButton((IGuiWrapper)this, this.getGuiLeft() + 11, this.getGuiTop() + 141, 14, this.getButtonLocation("strict_input"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.INVERSE_BUTTON, this.tile)), this.getOnHover(MekanismLang.MINER_INVERSE)));
        this.radiusField = new TextFieldWidget(this.font, this.getGuiLeft() + 12, this.getGuiTop() + 67, 26, 11, "");
        this.addButton((Widget)this.radiusField);
        this.radiusField.func_146203_f(Integer.toString(MekanismConfig.general.minerMaxRadius.get()).length());
        this.minField = new TextFieldWidget(this.font, this.getGuiLeft() + 12, this.getGuiTop() + 92, 26, 11, "");
        this.addButton((Widget)this.minField);
        this.minField.func_146203_f(3);
        this.maxField = new TextFieldWidget(this.font, this.getGuiLeft() + 12, this.getGuiTop() + 117, 26, 11, "");
        this.addButton((Widget)this.maxField);
        this.maxField.func_146203_f(3);
    }

    public void resize(@Nonnull Minecraft minecraft, int scaledWidth, int scaledHeight) {
        String prevRad = this.radiusField.func_146179_b();
        String prevMin = this.minField.func_146179_b();
        String prevMax = this.maxField.func_146179_b();
        super.resize(minecraft, scaledWidth, scaledHeight);
        this.radiusField.func_146180_a(prevRad);
        this.minField.func_146180_a(prevMin);
        this.maxField.func_146180_a(prevMax);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawString((ITextComponent)MekanismLang.MINER_CONFIG.translate(new Object[0]), 43, 6, 0x404040);
        this.drawString((ITextComponent)MekanismLang.FILTERS.translate(new Object[0]), 11, 19, 52480);
        this.drawString((ITextComponent)MekanismLang.FILTER_COUNT.translate(this.getFilters().size()), 11, 28, 52480);
        this.drawString((ITextComponent)MekanismLang.MINER_IS_INVERSE.translate(BooleanStateDisplay.OnOff.of(((TileEntityDigitalMiner)this.tile).inverse)), 11, 131, 52480);
        this.drawString((ITextComponent)MekanismLang.MINER_RADIUS.translate(((TileEntityDigitalMiner)this.tile).getRadius()), 11, 58, 52480);
        this.drawString((ITextComponent)MekanismLang.MIN.translate(((TileEntityDigitalMiner)this.tile).getMinY()), 11, 83, 52480);
        this.drawString((ITextComponent)MekanismLang.MAX.translate(((TileEntityDigitalMiner)this.tile).getMaxY()), 11, 108, 52480);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof IItemStackFilter) {
            Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DM_FILTER_ITEMSTACK, this.tile, index));
        } else if (filter instanceof ITagFilter) {
            Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DM_FILTER_TAG, this.tile, index));
        } else if (filter instanceof IMaterialFilter) {
            Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DM_FILTER_MATERIAL, this.tile, index));
        } else if (filter instanceof IModIDFilter) {
            Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.DM_FILTER_MOD_ID, this.tile, index));
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        TextFieldWidget focusedField = this.getFocusedField();
        if (focusedField != null) {
            if (keyCode == 256) {
                focusedField.func_146195_b(false);
                return true;
            }
            if (keyCode == 257) {
                if (this.radiusField.func_212955_f()) {
                    this.setRadius();
                } else if (this.minField.func_212955_f()) {
                    this.setMinY();
                } else if (this.maxField.func_212955_f()) {
                    this.setMaxY();
                }
                return true;
            }
            return focusedField.keyPressed(keyCode, scanCode, modifiers);
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean charTyped(char c, int keyCode) {
        TextFieldWidget focusedField = this.getFocusedField();
        if (focusedField != null) {
            if (Character.isDigit(c)) {
                return focusedField.charTyped(c, keyCode);
            }
            return false;
        }
        return super.charTyped(c, keyCode);
    }

    @Nullable
    private TextFieldWidget getFocusedField() {
        if (this.radiusField.func_212955_f()) {
            return this.radiusField;
        }
        if (this.minField.func_212955_f()) {
            return this.minField;
        }
        if (this.maxField.func_212955_f()) {
            return this.maxField;
        }
        return null;
    }

    private void setRadius() {
        if (!this.radiusField.func_146179_b().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_RADIUS, this.tile, Integer.parseInt(this.radiusField.func_146179_b())));
            this.radiusField.func_146180_a("");
        }
    }

    private void setMinY() {
        if (!this.minField.func_146179_b().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_MIN_Y, this.tile, Integer.parseInt(this.minField.func_146179_b())));
            this.minField.func_146180_a("");
        }
    }

    private void setMaxY() {
        if (!this.maxField.func_146179_b().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_MAX_Y, this.tile, Integer.parseInt(this.maxField.func_146179_b())));
            this.maxField.func_146180_a("");
        }
    }

    @Override
    protected List<ItemStack> getTagStacks(String tagName) {
        return TagCache.getBlockTagStacks(tagName);
    }
}

