/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import mekanism.client.MekKeyHandler;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.item.IModeItem;
import mekanism.common.network.PacketModeChange;
import mekanism.common.registries.MekanismSounds;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class MekanismKeyHandler
extends MekKeyHandler {
    public static KeyBinding modeSwitchKey = new KeyBinding(MekanismLang.KEY_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 78, MekanismLang.MEKANISM.getTranslationKey());
    public static KeyBinding armorModeSwitchKey = new KeyBinding(MekanismLang.KEY_ARMOR_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 71, MekanismLang.MEKANISM.getTranslationKey());
    public static KeyBinding freeRunnerModeSwitchKey = new KeyBinding(MekanismLang.KEY_FEET_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputMappings.Type.KEYSYM, 72, MekanismLang.MEKANISM.getTranslationKey());
    public static KeyBinding detailsKey = new KeyBinding(MekanismLang.KEY_DETAILS_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.GUI, InputMappings.Type.KEYSYM, 340, MekanismLang.MEKANISM.getTranslationKey());
    public static KeyBinding descriptionKey = new KeyBinding(MekanismLang.KEY_DESCRIPTION_MODE.getTranslationKey(), (IKeyConflictContext)KeyConflictContext.GUI, KeyModifier.SHIFT, InputMappings.Type.KEYSYM, 78, MekanismLang.MEKANISM.getTranslationKey());
    private static MekKeyHandler.Builder BINDINGS = new MekKeyHandler.Builder(5).addBinding(modeSwitchKey, false).addBinding(armorModeSwitchKey, false).addBinding(freeRunnerModeSwitchKey, false).addBinding(detailsKey, false).addBinding(descriptionKey, false);

    public MekanismKeyHandler() {
        super(BINDINGS);
        ClientRegistry.registerKeyBinding((KeyBinding)modeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)armorModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)freeRunnerModeSwitchKey);
        ClientRegistry.registerKeyBinding((KeyBinding)detailsKey);
        ClientRegistry.registerKeyBinding((KeyBinding)descriptionKey);
        MinecraftForge.EVENT_BUS.addListener(this::onTick);
    }

    private void onTick(InputEvent.KeyInputEvent event) {
        this.keyTick();
    }

    @Override
    public void keyDown(KeyBinding kb, boolean isRepeat) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (kb == modeSwitchKey) {
            if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.MAINHAND)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.MAINHAND, player.func_225608_bj_()));
            } else if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.OFFHAND)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.OFFHAND, player.func_225608_bj_()));
            }
        } else if (kb == armorModeSwitchKey) {
            if (IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.CHEST)) {
                Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.CHEST, player.func_225608_bj_()));
                SoundHandler.playSound(MekanismSounds.HYDRAULIC.getSoundEvent());
            }
        } else if (kb == freeRunnerModeSwitchKey && IModeItem.isModeItem((PlayerEntity)player, EquipmentSlotType.FEET)) {
            Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.FEET, player.func_225608_bj_()));
            SoundHandler.playSound(MekanismSounds.HYDRAULIC.getSoundEvent());
        }
    }

    @Override
    public void keyUp(KeyBinding kb) {
    }
}

