/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraftforge.client.settings.KeyModifier;
import org.lwjgl.glfw.GLFW;

public abstract class MekKeyHandler {
    private KeyBinding[] keyBindings;
    private BitSet keyDown;
    private BitSet repeatings;

    public MekKeyHandler(Builder bindings) {
        this.keyBindings = bindings.getBindings();
        this.repeatings = bindings.getRepeatFlags();
        this.keyDown = new BitSet();
    }

    public static boolean getIsKeyPressed(KeyBinding keyBinding) {
        if (keyBinding.func_151470_d()) {
            return true;
        }
        if (keyBinding.getKeyConflictContext().isActive() && keyBinding.getKeyModifier().isActive(keyBinding.getKeyConflictContext())) {
            return MekKeyHandler.isKeyPressed(keyBinding);
        }
        return KeyModifier.isKeyCodeModifier((InputMappings.Input)keyBinding.getKey()) && MekKeyHandler.isKeyPressed(keyBinding);
    }

    private static boolean isKeyPressed(KeyBinding keyBinding) {
        InputMappings.Input key = keyBinding.getKey();
        int keyCode = key.func_197937_c();
        if (keyCode != InputMappings.field_197958_a.func_197937_c()) {
            long windowHandle = Minecraft.func_71410_x().func_228018_at_().func_198092_i();
            try {
                if (key.func_197938_b() == InputMappings.Type.KEYSYM) {
                    return InputMappings.func_216506_a((long)windowHandle, (int)keyCode);
                }
                if (key.func_197938_b() == InputMappings.Type.MOUSE) {
                    return GLFW.glfwGetMouseButton((long)windowHandle, (int)keyCode) == 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void keyTick() {
        for (int i = 0; i < this.keyBindings.length; ++i) {
            boolean lastState;
            KeyBinding keyBinding = this.keyBindings[i];
            boolean state = keyBinding.func_151470_d();
            if (state == (lastState = this.keyDown.get(i)) && (!state || !this.repeatings.get(i))) continue;
            if (state) {
                this.keyDown(keyBinding, lastState);
            } else {
                this.keyUp(keyBinding);
            }
            this.keyDown.set(i, state);
        }
    }

    public abstract void keyDown(KeyBinding var1, boolean var2);

    public abstract void keyUp(KeyBinding var1);

    public static class Builder {
        private final List<KeyBinding> bindings;
        private final BitSet repeatFlags = new BitSet();

        public Builder(int expectedCapacity) {
            this.bindings = new ArrayList<KeyBinding>(expectedCapacity);
        }

        public Builder addBinding(KeyBinding k, boolean repeatFlag) {
            this.repeatFlags.set(this.bindings.size(), repeatFlag);
            this.bindings.add(k);
            return this;
        }

        protected BitSet getRepeatFlags() {
            return this.repeatFlags;
        }

        protected KeyBinding[] getBindings() {
            return this.bindings.toArray(new KeyBinding[0]);
        }
    }
}

