/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import mekanism.api.chemical.gas.GasStack;
import mekanism.client.MekanismClient;
import mekanism.client.render.RenderTickHandler;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.HolidayManager;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.frequency.Frequency;
import mekanism.common.item.IModeItem;
import mekanism.common.item.gear.ItemFlamethrower;
import mekanism.common.item.gear.ItemJetpack;
import mekanism.common.item.gear.ItemScubaTank;
import mekanism.common.network.PacketModeChange;
import mekanism.common.network.PacketPortableTeleporterGui;
import mekanism.common.util.GasUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientTickHandler {
    public static Minecraft minecraft = Minecraft.func_71410_x();
    public static Random rand = new Random();
    public static Map<PlayerEntity, TeleportData> portableTeleports = new Object2ObjectOpenHashMap();
    public boolean initHoliday = false;
    public boolean shouldReset = false;
    public static boolean firstTick = true;

    public static boolean isJetpackActive(PlayerEntity player) {
        ItemStack chest;
        if (player != ClientTickHandler.minecraft.field_71439_g) {
            return Mekanism.playerState.isJetpackOn(player);
        }
        if (!player.func_184812_l_() && !player.func_175149_v() && !(chest = player.func_184582_a(EquipmentSlotType.CHEST)).func_190926_b() && chest.func_77973_b() instanceof ItemJetpack && GasUtils.hasGas(chest)) {
            ItemJetpack.JetpackMode mode = ((ItemJetpack)chest.func_77973_b()).getMode(chest);
            if (mode == ItemJetpack.JetpackMode.NORMAL) {
                return ClientTickHandler.minecraft.field_71462_r == null && ClientTickHandler.minecraft.field_71474_y.field_74314_A.func_151470_d();
            }
            if (mode == ItemJetpack.JetpackMode.HOVER) {
                boolean ascending = ClientTickHandler.minecraft.field_71474_y.field_74314_A.func_151470_d();
                boolean descending = ClientTickHandler.minecraft.field_71474_y.field_228046_af_.func_151470_d();
                if (!ascending || descending || ClientTickHandler.minecraft.field_71462_r != null) {
                    return !CommonPlayerTickHandler.isOnGround(player);
                }
                return true;
            }
        }
        return false;
    }

    public static boolean isGasMaskOn(PlayerEntity player) {
        if (player != ClientTickHandler.minecraft.field_71439_g) {
            return Mekanism.playerState.isGasmaskOn(player);
        }
        return CommonPlayerTickHandler.isGasMaskOn(player);
    }

    public static boolean isFlamethrowerOn(PlayerEntity player) {
        if (player != ClientTickHandler.minecraft.field_71439_g) {
            return Mekanism.playerState.isFlamethrowerOn(player);
        }
        return ClientTickHandler.hasFlamethrower(player) && ClientTickHandler.minecraft.field_71474_y.field_74313_G.func_151470_d();
    }

    public static boolean hasFlamethrower(PlayerEntity player) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        return !currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower && GasUtils.hasGas(currentItem);
    }

    public static void portableTeleport(PlayerEntity player, Hand hand, Frequency freq) {
        int delay = MekanismConfig.gear.portableTeleporterDelay.get();
        if (delay == 0) {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.TELEPORT, hand, freq));
        } else {
            portableTeleports.put(player, new TeleportData(hand, freq, ClientTickHandler.minecraft.field_71441_e.func_72820_D() + (long)delay));
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart();
        }
    }

    public void tickStart() {
        ++MekanismClient.ticksPassed;
        if (ClientTickHandler.minecraft.field_71441_e != null && firstTick) {
            MekanismClient.launchClient();
            firstTick = false;
        }
        if (ClientTickHandler.minecraft.field_71441_e != null) {
            this.shouldReset = true;
        } else if (this.shouldReset) {
            MekanismClient.reset();
            this.shouldReset = false;
        }
        if (ClientTickHandler.minecraft.field_71441_e != null && ClientTickHandler.minecraft.field_71439_g != null && !Mekanism.proxy.isPaused()) {
            if (!this.initHoliday || MekanismClient.ticksPassed % 1200L == 0L) {
                HolidayManager.check((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
                this.initHoliday = true;
            }
            UUID playerUUID = ClientTickHandler.minecraft.field_71439_g.func_110124_au();
            if (CommonPlayerTickHandler.isFreeRunnerOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                ClientTickHandler.minecraft.field_71439_g.field_70138_W = 1.002f;
            } else if (ClientTickHandler.minecraft.field_71439_g.field_70138_W == 1.002f) {
                ClientTickHandler.minecraft.field_71439_g.field_70138_W = 0.6f;
            }
            Mekanism.playerState.setJetpackState(playerUUID, ClientTickHandler.isJetpackActive((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), true);
            Mekanism.playerState.setGasmaskState(playerUUID, ClientTickHandler.isGasMaskOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), true);
            Mekanism.playerState.setFlamethrowerState(playerUUID, ClientTickHandler.hasFlamethrower((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), ClientTickHandler.isFlamethrowerOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g), true);
            Iterator<Map.Entry<PlayerEntity, TeleportData>> iter = portableTeleports.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<PlayerEntity, TeleportData> entry = iter.next();
                PlayerEntity player = entry.getKey();
                for (int i = 0; i < 100; ++i) {
                    double x = player.func_226277_ct_() + rand.nextDouble() - 0.5;
                    double y = player.func_226278_cu_() + rand.nextDouble() * 2.0 - 2.0;
                    double z = player.func_226281_cx_() + rand.nextDouble() - 0.5;
                    ClientTickHandler.minecraft.field_71441_e.func_195594_a((IParticleData)ParticleTypes.field_197599_J, x, y, z, 0.0, 1.0, 0.0);
                }
                if (ClientTickHandler.minecraft.field_71441_e.func_72820_D() != entry.getValue().teleportTime) continue;
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporterGui(PacketPortableTeleporterGui.PortableTeleporterPacketType.TELEPORT, entry.getValue().hand, entry.getValue().freq));
                iter.remove();
            }
            ItemStack chestStack = ClientTickHandler.minecraft.field_71439_g.func_184582_a(EquipmentSlotType.CHEST);
            if (!chestStack.func_190926_b() && chestStack.func_77973_b() instanceof ItemJetpack) {
                MekanismClient.updateKey(ClientTickHandler.minecraft.field_71474_y.field_74314_A, KeySync.ASCEND);
                MekanismClient.updateKey(ClientTickHandler.minecraft.field_71474_y.field_228046_af_, KeySync.DESCEND);
            }
            if (!ClientTickHandler.minecraft.field_71439_g.func_184812_l_() && !ClientTickHandler.minecraft.field_71439_g.func_175149_v() && ClientTickHandler.isFlamethrowerOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                ItemFlamethrower flamethrower = (ItemFlamethrower)ClientTickHandler.minecraft.field_71439_g.field_71071_by.func_70448_g().func_77973_b();
                flamethrower.useGas(ClientTickHandler.minecraft.field_71439_g.field_71071_by.func_70448_g(), 1L);
            }
            if (ClientTickHandler.isJetpackActive((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                ItemJetpack jetpack = (ItemJetpack)chestStack.func_77973_b();
                ItemJetpack.JetpackMode mode = jetpack.getMode(chestStack);
                Vec3d motion = ClientTickHandler.minecraft.field_71439_g.func_213322_ci();
                if (mode == ItemJetpack.JetpackMode.NORMAL) {
                    ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.5), motion.func_82616_c());
                    ClientTickHandler.minecraft.field_71439_g.field_70143_R = 0.0f;
                } else if (mode == ItemJetpack.JetpackMode.HOVER) {
                    boolean ascending = ClientTickHandler.minecraft.field_71474_y.field_74314_A.func_151470_d();
                    boolean descending = ClientTickHandler.minecraft.field_71474_y.field_228046_af_.func_151470_d();
                    if (!ascending && !descending || ascending && descending || ClientTickHandler.minecraft.field_71462_r != null) {
                        if (motion.func_82617_b() > 0.0) {
                            ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, 0.0), motion.func_82616_c());
                        } else if (motion.func_82617_b() < 0.0 && !CommonPlayerTickHandler.isOnGround((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                            ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.0), motion.func_82616_c());
                        }
                    } else if (ascending) {
                        ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.min(motion.func_82617_b() + 0.15, 0.2), motion.func_82616_c());
                    } else if (!CommonPlayerTickHandler.isOnGround((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                        ClientTickHandler.minecraft.field_71439_g.func_213293_j(motion.func_82615_a(), Math.max(motion.func_82617_b() - 0.15, -0.2), motion.func_82616_c());
                    }
                    ClientTickHandler.minecraft.field_71439_g.field_70143_R = 0.0f;
                }
                jetpack.useGas(chestStack, 1L);
            }
            if (ClientTickHandler.isGasMaskOn((PlayerEntity)ClientTickHandler.minecraft.field_71439_g)) {
                ItemScubaTank tank = (ItemScubaTank)chestStack.func_77973_b();
                int max = 300;
                tank.useGas(chestStack, 1L);
                GasStack received = tank.useGas(chestStack, 300 - ClientTickHandler.minecraft.field_71439_g.func_70086_ai());
                if (!received.isEmpty()) {
                    ClientTickHandler.minecraft.field_71439_g.func_70050_g(ClientTickHandler.minecraft.field_71439_g.func_70086_ai() + (int)received.getAmount());
                }
                if (ClientTickHandler.minecraft.field_71439_g.func_70086_ai() == 300) {
                    for (EffectInstance effect : ClientTickHandler.minecraft.field_71439_g.func_70651_bq()) {
                        for (int i = 0; i < 9; ++i) {
                            effect.func_76455_a((LivingEntity)ClientTickHandler.minecraft.field_71439_g, () -> MekanismUtils.onChangedPotionEffect((LivingEntity)ClientTickHandler.minecraft.field_71439_g, effect, true));
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onMouseEvent(InputEvent.MouseScrollEvent event) {
        int shift;
        if (MekanismConfig.client.allowModeScroll.get() && ClientTickHandler.minecraft.field_71439_g != null && ClientTickHandler.minecraft.field_71439_g.func_225608_bj_() && (shift = (int)event.getScrollDelta()) != 0 && IModeItem.isModeItem((PlayerEntity)ClientTickHandler.minecraft.field_71439_g, EquipmentSlotType.MAINHAND)) {
            RenderTickHandler.modeSwitchTimer = 100;
            Mekanism.packetHandler.sendToServer(new PacketModeChange(EquipmentSlotType.MAINHAND, shift));
            event.setCanceled(true);
        }
    }

    private static class TeleportData {
        private Hand hand;
        private Frequency freq;
        private long teleportTime;

        public TeleportData(Hand h, Frequency f, long t) {
            this.hand = h;
            this.freq = f;
            this.teleportTime = t;
        }
    }
}

