/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.ItemStackToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackToGasCachedRecipe
extends CachedRecipe<ItemStackToGasRecipe> {
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;

    public ItemStackToGasCachedRecipe(ItemStackToGasRecipe recipe, IInputHandler<@NonNull ItemStack> inputHandler, IOutputHandler<@NonNull GasStack> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToGasRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((ItemStackToGasRecipe)this.recipe).getInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((ItemStackToGasRecipe)this.recipe).getOutput(recipeItem), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((ItemStackToGasRecipe)this.recipe).test(this.inputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.inputHandler.getRecipeInput(((ItemStackToGasRecipe)this.recipe).getInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        this.inputHandler.use(recipeItem, operations);
        this.outputHandler.handleOutput(((ItemStackToGasRecipe)this.recipe).getOutput(recipeItem), operations);
    }
}

