/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.FluidGasToGasRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraftforge.fluids.FluidStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class FluidGasToGasCachedRecipe
extends CachedRecipe<FluidGasToGasRecipe> {
    private final IOutputHandler<@NonNull GasStack> outputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;

    public FluidGasToGasCachedRecipe(FluidGasToGasRecipe recipe, IInputHandler<@NonNull FluidStack> fluidInputHandler, IInputHandler<@NonNull GasStack> gasInputHandler, IOutputHandler<@NonNull GasStack> outputHandler) {
        super(recipe);
        this.fluidInputHandler = fluidInputHandler;
        this.gasInputHandler = gasInputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((FluidGasToGasRecipe)this.recipe).getFluidInput());
        if (recipeFluid.isEmpty()) {
            return -1;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((FluidGasToGasRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return -1;
        }
        currentMax = this.fluidInputHandler.operationsCanSupport(((FluidGasToGasRecipe)this.recipe).getFluidInput(), currentMax);
        currentMax = this.gasInputHandler.operationsCanSupport(((FluidGasToGasRecipe)this.recipe).getGasInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((FluidGasToGasRecipe)this.recipe).getOutput(recipeFluid, recipeGas), currentMax);
    }

    @Override
    public boolean isInputValid() {
        FluidStack fluidStack = this.fluidInputHandler.getInput();
        if (fluidStack.isEmpty()) {
            return false;
        }
        GasStack gasInput = this.gasInputHandler.getInput();
        if (gasInput.isEmpty()) {
            return false;
        }
        return ((FluidGasToGasRecipe)this.recipe).test(fluidStack, gasInput);
    }

    @Override
    protected void finishProcessing(int operations) {
        FluidStack recipeFluid = this.fluidInputHandler.getRecipeInput(((FluidGasToGasRecipe)this.recipe).getFluidInput());
        if (recipeFluid.isEmpty()) {
            return;
        }
        GasStack recipeGas = this.gasInputHandler.getRecipeInput(((FluidGasToGasRecipe)this.recipe).getGasInput());
        if (recipeGas.isEmpty()) {
            return;
        }
        this.fluidInputHandler.use(recipeFluid, operations);
        this.gasInputHandler.use(recipeGas, operations);
        this.outputHandler.handleOutput(((FluidGasToGasRecipe)this.recipe).getOutput(recipeFluid, recipeGas), operations);
    }
}

