/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache;

import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.recipes.CombinerRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class CombinerCachedRecipe
extends CachedRecipe<CombinerRecipe> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> inputHandler;
    private final IInputHandler<@NonNull ItemStack> extraInputHandler;

    public CombinerCachedRecipe(CombinerRecipe recipe, IInputHandler<@NonNull ItemStack> inputHandler, IInputHandler<@NonNull ItemStack> extraInputHandler, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.inputHandler = inputHandler;
        this.extraInputHandler = extraInputHandler;
        this.outputHandler = outputHandler;
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeMain = this.inputHandler.getRecipeInput(((CombinerRecipe)this.recipe).getMainInput());
        if (recipeMain.func_190926_b()) {
            return -1;
        }
        ItemStack recipeExtra = this.extraInputHandler.getRecipeInput(((CombinerRecipe)this.recipe).getExtraInput());
        if (recipeExtra.func_190926_b()) {
            return -1;
        }
        currentMax = this.inputHandler.operationsCanSupport(((CombinerRecipe)this.recipe).getMainInput(), currentMax);
        currentMax = this.extraInputHandler.operationsCanSupport(((CombinerRecipe)this.recipe).getExtraInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        return this.outputHandler.operationsRoomFor(((CombinerRecipe)this.recipe).getOutput(recipeMain, recipeExtra), currentMax);
    }

    @Override
    public boolean isInputValid() {
        return ((CombinerRecipe)this.recipe).test(this.inputHandler.getInput(), this.extraInputHandler.getInput());
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeMain = this.inputHandler.getRecipeInput(((CombinerRecipe)this.recipe).getMainInput());
        if (recipeMain.func_190926_b()) {
            return;
        }
        ItemStack recipeExtra = this.extraInputHandler.getRecipeInput(((CombinerRecipe)this.recipe).getExtraInput());
        if (recipeExtra.func_190926_b()) {
            return;
        }
        this.inputHandler.use(recipeMain, operations);
        this.extraInputHandler.use(recipeExtra, operations);
        this.outputHandler.handleOutput(((CombinerRecipe)this.recipe).getOutput(recipeMain, recipeExtra), operations);
    }
}

