/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes;

import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.GasStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class ChemicalInfuserRecipe
extends MekanismRecipe
implements BiPredicate<GasStack, GasStack> {
    private final GasStackIngredient leftInput;
    private final GasStackIngredient rightInput;
    private final GasStack output;

    public ChemicalInfuserRecipe(ResourceLocation id, GasStackIngredient leftInput, GasStackIngredient rightInput, GasStack output) {
        super(id);
        this.leftInput = leftInput;
        this.rightInput = rightInput;
        this.output = output;
    }

    @Override
    public boolean test(GasStack input1, GasStack input2) {
        return this.leftInput.test(input1) && this.rightInput.test(input2) || this.rightInput.test(input1) && this.leftInput.test(input2);
    }

    public GasStack getOutput(GasStack input1, GasStack input2) {
        return this.output.copy();
    }

    public GasStackIngredient getLeftInput() {
        return this.leftInput;
    }

    public GasStackIngredient getRightInput() {
        return this.rightInput;
    }

    public List<GasStack> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.leftInput.write(buffer);
        this.rightInput.write(buffer);
        this.output.writeToPacket(buffer);
    }
}

