/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.chemical.infuse;

import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.Action;
import mekanism.api.chemical.IChemicalHandlerWrapper;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class InfusionHandlerWrapper
implements IChemicalHandlerWrapper<InfuseType, InfusionStack> {
    @Nonnull
    private final IInfusionHandler handler;

    public InfusionHandlerWrapper(IInfusionHandler handler) {
        this.handler = handler;
    }

    @Override
    public int getTanks() {
        return this.handler.getInfusionTankCount();
    }

    @Override
    public InfusionStack getChemicalInTank(int tank) {
        return this.handler.getInfusionInTank(tank);
    }

    @Override
    public void setChemicalInTank(int tank, InfusionStack stack) {
        this.handler.setInfusionInTank(tank, stack);
    }

    @Override
    public long getTankCapacity(int tank) {
        return this.handler.getInfusionTankCapacity(tank);
    }

    @Override
    public boolean isChemicalValid(int tank, InfusionStack stack) {
        return this.handler.isInfusionValid(tank, stack);
    }

    @Override
    public InfusionStack insertChemical(int tank, InfusionStack stack, Action action) {
        return this.handler.insertInfusion(tank, stack, action);
    }

    @Override
    public InfusionStack extractChemical(int tank, long amount, Action action) {
        return this.handler.extractInfusion(tank, amount, action);
    }

    @Override
    public InfusionStack insertChemical(InfusionStack stack, Action action) {
        return this.handler.insertInfusion(stack, action);
    }

    @Override
    public InfusionStack extractChemical(long amount, Action action) {
        return this.handler.extractInfusion(amount, action);
    }

    @Override
    public InfusionStack extractChemical(InfusionStack stack, Action action) {
        return this.handler.extractInfusion(stack, action);
    }
}

